/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology;

import java.util.List;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;

public class Morphologies {
    private Morphologies() {
    }

    public static final long[][] computeMinSize(Interval source, List<Shape> shapes) {
        int numDims = source.numDimensions();
        long[] min = new long[numDims];
        long[] size = new long[numDims];
        for (int i = 0; i < numDims; ++i) {
            min[i] = source.min(i);
            size[i] = source.dimension(i);
        }
        for (Shape shape : shapes) {
            Neighborhood nh = MorphologyUtils.getNeighborhood((Shape)shape, (EuclideanSpace)source);
            for (int i = 0; i < numDims; ++i) {
                int n = i;
                min[n] = min[n] + nh.min(i);
                int n2 = i;
                size[n2] = size[n2] + (nh.dimension(i) - 1L);
            }
        }
        return new long[][]{min, size};
    }
}

