/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.Kurtosis.class, label="Statistics: Kurtosis")
public class DefaultKurtosis<I extends RealType<I>, O extends RealType<O>>
extends AbstractStatsOp<Iterable<I>, O>
implements Ops.Stats.Kurtosis {
    private UnaryFunctionOp<Iterable<I>, O> stdDevFunc;
    private UnaryFunctionOp<Iterable<I>, O> moment4AboutMeanFunc;

    @Override
    public void initialize() {
        this.stdDevFunc = RTs.function(this.ops(), Ops.Stats.StdDev.class, this.in(), new Object[0]);
        this.moment4AboutMeanFunc = RTs.function(this.ops(), Ops.Stats.Moment4AboutMean.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Iterable<I> input, O output) {
        output.setReal(Double.NaN);
        double std = ((RealType)this.stdDevFunc.calculate(input)).getRealDouble();
        double moment4 = ((RealType)this.moment4AboutMeanFunc.calculate(input)).getRealDouble();
        if (std != 0.0) {
            output.setReal(moment4 / (std * std * std * std));
        }
    }
}

