/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.isoData;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.IsoData.class, priority=100.0)
public class ComputeIsoDataThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.IsoData {
    @Parameter(type=ItemIO.OUTPUT)
    private String errMsg = null;

    @Override
    public long computeBin(Histogram1d<T> hist) {
        int g;
        block4: {
            int i;
            long[] histogram = hist.toLongArray();
            g = 0;
            for (i = 1; i < histogram.length; ++i) {
                if (histogram[i] <= 0L) continue;
                g = i + 1;
                break;
            }
            do {
                long l = 0L;
                long totl = 0L;
                for (i = 0; i < g; ++i) {
                    totl += histogram[i];
                    l += histogram[i] * (long)i;
                }
                long h = 0L;
                long toth = 0L;
                for (i = g + 1; i < histogram.length; ++i) {
                    toth += histogram[i];
                    h += histogram[i] * (long)i;
                }
                if (totl > 0L && toth > 0L && g == (int)Math.round((double)((l /= totl) + (h /= toth)) / 2.0)) break block4;
            } while (++g <= histogram.length - 2);
            this.errMsg = "IsoData Threshold not found.";
            return -1L;
        }
        return g;
    }
}

