/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.clahe;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import mpicbg.ij.clahe.Apply;
import mpicbg.ij.clahe.Flat;
import mpicbg.ij.clahe.Util;

public class FastFlat
extends Flat {
    @Deprecated
    public static void run(ImagePlus imp, int blockRadius, int bins, float slope, ByteProcessor mask) {
        FastFlat.getFastInstance().run(imp, blockRadius, bins, slope, mask, true);
    }

    private static final int[] createHistogram(int blockRadius, int bins, int blockXCenter, int blockYCenter, ByteProcessor src) {
        int[] hist = new int[bins + 1];
        int xMin = Math.max(0, blockXCenter - blockRadius);
        int yMin = Math.max(0, blockYCenter - blockRadius);
        int xMax = Math.min(src.getWidth(), blockXCenter + blockRadius + 1);
        int yMax = Math.min(src.getHeight(), blockYCenter + blockRadius + 1);
        for (int y = yMin; y < yMax; ++y) {
            int row = src.getWidth() * y;
            for (int x = xMin; x < xMax; ++x) {
                int n = mpicbg.util.Util.roundPos((float)src.get(row + x) / 255.0f * (float)bins);
                hist[n] = hist[n] + 1;
            }
        }
        return hist;
    }

    @Override
    protected final void run(ImagePlus imp, int blockRadius, int bins, float slope, int boxXMin, int boxYMin, int boxXMax, int boxYMax, ByteProcessor src, ByteProcessor dst, ByteProcessor mask, ImageProcessor ip, boolean composite, ArrayList<Apply<?>> appliers) {
        int[] rs;
        int[] cs;
        boolean updatePerRow = imp.isVisible();
        boolean updatePerCell = updatePerRow & !composite;
        int blockSize = 2 * blockRadius + 1;
        int limit = (int)(slope * (float)blockSize * (float)blockSize / (float)bins + 0.5f);
        int nc = src.getWidth() / blockSize;
        int nr = src.getHeight() / blockSize;
        int cm = src.getWidth() - nc * blockSize;
        switch (cm) {
            case 0: {
                int i;
                cs = new int[nc];
                for (i = 0; i < nc; ++i) {
                    cs[i] = i * blockSize + blockRadius + 1;
                }
                break;
            }
            case 1: {
                int i;
                cs = new int[nc + 1];
                for (i = 0; i < nc; ++i) {
                    cs[i] = i * blockSize + blockRadius + 1;
                }
                cs[nc] = src.getWidth() - blockRadius - 1;
                break;
            }
            default: {
                int i;
                cs = new int[nc + 2];
                cs[0] = blockRadius + 1;
                for (i = 0; i < nc; ++i) {
                    cs[i + 1] = i * blockSize + blockRadius + 1 + cm / 2;
                }
                cs[nc + 1] = src.getWidth() - blockRadius - 1;
            }
        }
        int rm = src.getHeight() - nr * blockSize;
        switch (rm) {
            case 0: {
                int i;
                rs = new int[nr];
                for (i = 0; i < nr; ++i) {
                    rs[i] = i * blockSize + blockRadius + 1;
                }
                break;
            }
            case 1: {
                int i;
                rs = new int[nr + 1];
                for (i = 0; i < nr; ++i) {
                    rs[i] = i * blockSize + blockRadius + 1;
                }
                rs[nr] = src.getHeight() - blockRadius - 1;
                break;
            }
            default: {
                int i;
                rs = new int[nr + 2];
                rs[0] = blockRadius + 1;
                for (i = 0; i < nr; ++i) {
                    rs[i + 1] = i * blockSize + blockRadius + 1 + rm / 2;
                }
                rs[nr + 1] = src.getHeight() - blockRadius - 1;
            }
        }
        for (int r = 0; r <= rs.length; ++r) {
            float[] br;
            int r0 = Math.max(0, r - 1);
            int r1 = Math.min(rs.length - 1, r);
            int dr = rs[r1] - rs[r0];
            int[] hist = FastFlat.createHistogram(blockRadius, bins, cs[0], rs[r0], src);
            float[] tr = Util.createTransfer(hist, limit);
            if (r0 == r1) {
                br = tr;
            } else {
                hist = FastFlat.createHistogram(blockRadius, bins, cs[0], rs[r1], src);
                br = Util.createTransfer(hist, limit);
            }
            int yMin = r == 0 ? 0 : rs[r0];
            int yMax = r < rs.length ? rs[r1] : ip.getHeight() - 1;
            for (int c = 0; c <= cs.length; ++c) {
                int c0 = Math.max(0, c - 1);
                int c1 = Math.min(cs.length - 1, c);
                int dc = cs[c1] - cs[c0];
                float[] tl = tr;
                float[] bl = br;
                if (c0 != c1) {
                    hist = FastFlat.createHistogram(blockRadius, bins, cs[c1], rs[r0], src);
                    tr = Util.createTransfer(hist, limit);
                    if (r0 == r1) {
                        br = tr;
                    } else {
                        hist = FastFlat.createHistogram(blockRadius, bins, cs[c1], rs[r1], src);
                        br = Util.createTransfer(hist, limit);
                    }
                }
                int xMin = c == 0 ? 0 : cs[c0];
                int xMax = c < cs.length ? cs[c1] : ip.getWidth() - 1;
                for (int y = yMin; y < yMax; ++y) {
                    int o = y * ip.getWidth();
                    float wy = (float)(rs[r1] - y) / (float)dr;
                    for (int x = xMin; x < xMax; ++x) {
                        float t1;
                        float t0;
                        float wx = (float)(cs[c1] - x) / (float)dc;
                        int v = mpicbg.util.Util.roundPos((float)src.get(o + x) / 255.0f * (float)bins);
                        float t00 = tl[v];
                        float t01 = tr[v];
                        float t10 = bl[v];
                        float t11 = br[v];
                        if (c0 == c1) {
                            t0 = t00;
                            t1 = t10;
                        } else {
                            t0 = wx * t00 + (1.0f - wx) * t01;
                            t1 = wx * t10 + (1.0f - wx) * t11;
                        }
                        float t = r0 == r1 ? t0 : wy * t0 + (1.0f - wy) * t1;
                        dst.set(o + x, Math.max(0, Math.min(255, mpicbg.util.Util.roundPos(t * 255.0f))));
                    }
                }
                if (!updatePerCell) continue;
                for (Apply<?> apply : appliers) {
                    apply.apply(xMin, yMin, xMax, yMax);
                }
                imp.updateAndDraw();
            }
            if (!updatePerRow || updatePerCell) continue;
            for (Apply<?> apply : appliers) {
                apply.apply(boxXMin, yMin, boxXMax, yMax);
            }
            imp.updateAndDraw();
        }
        if (!updatePerRow) {
            for (Apply<?> apply : appliers) {
                apply.apply(boxXMin, boxYMin, boxXMax, boxYMax);
            }
            imp.updateAndDraw();
        }
    }
}

