/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.bdv;

import bdv.BigDataViewer;
import bdv.cache.SharedQueue;
import bdv.tools.InitializeViewerState;
import bdv.tools.boundingbox.BoxSelectionOptions;
import bdv.tools.brightness.ConverterSetup;
import bdv.ui.splitpanel.SplitPanel;
import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvHandleFrame;
import bdv.util.BdvHandlePanel;
import bdv.util.BdvOptions;
import bdv.util.Prefs;
import bdv.util.RandomAccessibleIntervalMipmapSource4D;
import bdv.util.volatiles.VolatileViews;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerFrame;
import bdv.viewer.ViewerPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ActionMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Cursor;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.Volatile;
import net.imglib2.algorithm.lazy.Lazy;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.ReadOnlyCachedCellImgFactory;
import net.imglib2.cache.img.ReadOnlyCachedCellImgOptions;
import net.imglib2.converter.Converters;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.type.volatiles.VolatileUnsignedLongType;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.control.mcu.MCUBDVControls;
import org.janelia.saalfeldlab.control.mcu.XTouchMiniMCUControlPanel;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.bdv.CropController;
import org.janelia.saalfeldlab.n5.bdv.MultiscaleDatasets;
import org.janelia.saalfeldlab.n5.bdv.N5ViewerCreator;
import org.janelia.saalfeldlab.n5.bdv.tools.boundingbox.BoxCrop;
import org.janelia.saalfeldlab.n5.ij.N5Importer;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.metadata.MetadataSource;
import org.janelia.saalfeldlab.n5.metadata.N5ViewerMultichannelMetadata;
import org.janelia.saalfeldlab.n5.ui.DataSelection;
import org.janelia.saalfeldlab.n5.universe.N5DatasetDiscoverer;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.N5MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.GenericMetadataGroup;
import org.janelia.saalfeldlab.n5.universe.metadata.MultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataGroup;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.DefaultAxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMultichannelMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalSpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.NgffSingleScaleAxesMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMultiScaleMetadata;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class N5Viewer {
    private int numTimepoints = 1;
    private final SharedQueue sharedQueue;
    private final BdvHandle bdv;

    public BdvHandle getBdv() {
        return this.bdv;
    }

    public SplitPanel getBdvSplitPanel() {
        return this.bdv.getSplitPanel();
    }

    public N5Viewer(Frame parent, DataSelection selection) throws IOException {
        this(parent, selection, true);
    }

    public <T extends NumericType<T> & NativeType<T>, V extends Volatile<T>, R extends N5Reader> N5Viewer(Frame parentFrame, DataSelection dataSelection, boolean wantFrame) throws IOException {
        Prefs.showScaleBar((boolean)true);
        this.sharedQueue = new SharedQueue(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
        ArrayList<N5Metadata> selected = new ArrayList<N5Metadata>();
        for (N5Metadata meta : dataSelection.metadata) {
            N5ViewerMultichannelMetadata mc;
            if (meta instanceof N5ViewerMultichannelMetadata) {
                mc = (N5ViewerMultichannelMetadata)meta;
                for (MultiscaleMetadata<?> multiscaleMetadata : mc.getChildrenMetadata()) {
                    selected.add((N5Metadata)multiscaleMetadata);
                }
                continue;
            }
            if (meta instanceof CanonicalMultichannelMetadata) {
                mc = (CanonicalMultichannelMetadata)meta;
                for (MultiscaleMetadata<?> multiscaleMetadata : mc.getChildrenMetadata()) {
                    selected.add((N5Metadata)multiscaleMetadata);
                }
                continue;
            }
            selected.add(meta);
        }
        N5Reader n5 = dataSelection.n5;
        this.bdv = N5Viewer.show(n5, selected, wantFrame, parentFrame);
    }

    public <T extends NumericType<T> & NativeType<T>, V extends Volatile<T>, R extends N5Reader> void addData(DataSelection selection) throws IOException {
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList<SourceAndConverter<T>> sourcesAndConverters = new ArrayList<SourceAndConverter<T>>();
        ArrayList<N5Metadata> selected = new ArrayList<N5Metadata>();
        for (N5Metadata meta : selection.metadata) {
            N5ViewerMultichannelMetadata mc;
            if (meta instanceof N5ViewerMultichannelMetadata) {
                mc = (N5ViewerMultichannelMetadata)meta;
                selected.addAll(Arrays.asList(mc.getChildrenMetadata()));
                continue;
            }
            if (meta instanceof CanonicalMultichannelMetadata) {
                mc = (CanonicalMultichannelMetadata)meta;
                selected.addAll(Arrays.asList(mc.getChildrenMetadata()));
                continue;
            }
            selected.add(meta);
        }
        BdvOptions opts = BdvOptions.options();
        this.numTimepoints = N5Viewer.buildN5Sources(selection.n5, selected, this.sharedQueue, converterSetups, sourcesAndConverters, opts);
        for (SourceAndConverter<T> sourcesAndConverter : sourcesAndConverters) {
            BdvFunctions.show(sourcesAndConverter, (int)this.numTimepoints, (BdvOptions)opts.addTo((Bdv)this.bdv));
        }
    }

    public static List<N5Metadata> unwrapMultichannelSelections(DataSelection dataSelection) {
        ArrayList<N5Metadata> selected = new ArrayList<N5Metadata>();
        for (N5Metadata meta : dataSelection.metadata) {
            if (meta instanceof N5ViewerMultichannelMetadata || meta instanceof CanonicalMultichannelMetadata || meta instanceof GenericMetadataGroup) {
                N5MetadataGroup mc = (N5MetadataGroup)meta;
                for (N5Metadata m : mc.getChildrenMetadata()) {
                    selected.add(m);
                }
                continue;
            }
            selected.add(meta);
        }
        return selected;
    }

    public static BdvHandle show(String uri) {
        try {
            return N5Viewer.show(new N5URI(uri));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BdvHandle show(N5URI uri) {
        return N5Viewer.show(new N5Factory().openReader(uri.getContainerPath()), uri.getGroupPath() != null ? uri.getGroupPath() : "/", true, null);
    }

    public static BdvHandle show(String n5root, String group) {
        return N5Viewer.show(new N5Factory().openReader(n5root), group, true, null);
    }

    public static BdvHandle show(N5Reader n5, String group) {
        return N5Viewer.show(n5, group, true, null);
    }

    public static <T extends NumericType<T> & NativeType<T>> BdvHandle show(N5Reader n5, String group, boolean wantFrame, Frame parentFrame) {
        return N5Viewer.show(n5, Collections.singletonList(N5MetadataUtils.parseMetadata((N5Reader)n5, (String)group)), wantFrame, parentFrame);
    }

    public static BdvHandle show(N5Reader n5, List<N5Metadata> metadata) {
        return N5Viewer.show(n5, metadata, true, null);
    }

    public static <T extends NumericType<T> & NativeType<T>> BdvHandle show(String[] uris, BdvOptions options) {
        return N5Viewer.show(uris, options, true, null);
    }

    public static <T extends NumericType<T> & NativeType<T>> BdvHandle show(String[] uris, BdvOptions options, boolean wantFrame, Frame parentFrame) {
        SharedQueue sharedQueue = new SharedQueue(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList<SourceAndConverter<T>> sourcesAndConverters = new ArrayList<SourceAndConverter<T>>();
        int numTimepoints = 1;
        HashMap<String, N5Reader> n5Readers = new HashMap<String, N5Reader>();
        HashMap selectionsByContainer = new HashMap();
        N5Importer.N5ViewerReaderFun n5fun = new N5Importer.N5ViewerReaderFun();
        for (String uri : uris) {
            N5URI n5uri;
            try {
                n5uri = new N5URI(uri);
            }
            catch (URISyntaxException e) {
                System.err.println("Could not parse url: " + uri);
                continue;
            }
            if (!n5Readers.containsKey(n5uri.getContainerPath())) {
                N5Reader n5 = n5fun.apply(n5uri.getContainerPath());
                n5Readers.put(n5uri.getContainerPath(), n5);
                selectionsByContainer.put(n5, new ArrayList());
                ((List)selectionsByContainer.get(n5)).add(N5URI.normalizeGroupPath((String)n5uri.getGroupPath()));
                continue;
            }
            ((List)selectionsByContainer.get(n5Readers.get(n5uri.getContainerPath()))).add(N5URI.normalizeGroupPath((String)n5uri.getGroupPath()));
        }
        for (N5Reader n5 : selectionsByContainer.keySet()) {
            N5TreeNode containerRoot = N5DatasetDiscoverer.discover((N5Reader)n5, Arrays.asList(N5ViewerCreator.n5vParsers), Arrays.asList(N5ViewerCreator.n5vGroupParsers));
            List metadataList = ((List)selectionsByContainer.get(n5)).stream().map(x -> containerRoot.getDescendant(x).map(n -> n.getMetadata())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            DataSelection selection = new DataSelection(n5, metadataList);
            try {
                numTimepoints = Math.max(numTimepoints, N5Viewer.buildN5Sources(n5, selection, sharedQueue, converterSetups, sourcesAndConverters, options));
            }
            catch (IOException e) {
                System.err.println("Could not load from: " + n5.getURI().toString());
            }
        }
        return N5Viewer.show(sourcesAndConverters, numTimepoints, options, wantFrame, parentFrame);
    }

    public static <T extends NumericType<T> & NativeType<T>> BdvHandle show(N5Reader n5, List<N5Metadata> metadata, boolean wantFrame, Frame parentFrame) {
        int numTimepoints;
        DataSelection selection = new DataSelection(n5, metadata);
        SharedQueue sharedQueue = new SharedQueue(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList<SourceAndConverter<T>> sourcesAndConverters = new ArrayList<SourceAndConverter<T>>();
        BdvOptions options = BdvOptions.options().frameTitle("N5 Viewer");
        try {
            numTimepoints = N5Viewer.buildN5Sources(n5, selection, sharedQueue, converterSetups, sourcesAndConverters, options);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return N5Viewer.show(sourcesAndConverters, numTimepoints, options, wantFrame, parentFrame);
    }

    public static <T extends NumericType<T> & NativeType<T>> BdvHandle show(List<SourceAndConverter<T>> sourcesAndConverters, int numTimepoints, BdvOptions options) {
        return N5Viewer.show(sourcesAndConverters, numTimepoints, options, true, null);
    }

    public static <T extends NumericType<T> & NativeType<T>> BdvHandle show(List<SourceAndConverter<T>> sourcesAndConverters, int numTimepoints, BdvOptions options, boolean wantFrame, Frame parentFrame) {
        ViewerPanel viewerPanel;
        BdvHandle bdvHandle = null;
        for (SourceAndConverter<T> sourcesAndConverter : sourcesAndConverters) {
            if (bdvHandle == null) {
                if (wantFrame) {
                    bdvHandle = BdvFunctions.show(sourcesAndConverter, (int)numTimepoints, (BdvOptions)options).getBdvHandle();
                    continue;
                }
                bdvHandle = new BdvHandlePanel(parentFrame, options);
                BdvFunctions.show(sourcesAndConverter, (int)numTimepoints, (BdvOptions)options.addTo((Bdv)bdvHandle));
                continue;
            }
            BdvFunctions.show(sourcesAndConverter, (int)numTimepoints, (BdvOptions)options.addTo(bdvHandle));
        }
        BdvHandle bdv = bdvHandle;
        if (bdv != null && (viewerPanel = bdv.getViewerPanel()) != null) {
            viewerPanel.setNumTimepoints(numTimepoints);
            N5Viewer.initCropController(bdv, sourcesAndConverters);
            viewerPanel.addComponentListener((ComponentListener)new ComponentAdapter(){
                boolean needsInit = true;

                @Override
                public void componentShown(ComponentEvent e) {
                    if (this.needsInit) {
                        InitializeViewerState.initTransform((AbstractViewerPanel)viewerPanel);
                        this.needsInit = false;
                    }
                }
            });
        }
        if (bdv instanceof BdvHandleFrame) {
            BdvHandleFrame bdvFrame = (BdvHandleFrame)bdv;
            ViewerFrame viewerFrame = bdvFrame.getBigDataViewer().getViewerFrame();
            JMenuBar menuBar = viewerFrame.getJMenuBar();
            ActionMap actionMap = viewerFrame.getKeybindings().getConcatenatedActionMap();
            JMenu toolsMenu = menuBar.getMenu(2);
            JMenuItem cropItem = new JMenuItem(actionMap.get("crop"));
            cropItem.setText("Extract to ImageJ");
            toolsMenu.add(cropItem);
            try {
                final XTouchMiniMCUControlPanel controlPanel = XTouchMiniMCUControlPanel.build();
                new MCUBDVControls(bdv.getBdvHandle().getViewerPanel(), controlPanel);
                ((JFrame)SwingUtilities.getWindowAncestor((Component)bdv.getBdvHandle().getViewerPanel())).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        controlPanel.close();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bdv;
    }

    public static <T extends NumericType<T> & NativeType<T>, V extends Volatile<T>> int buildN5Sources(N5Reader n5, DataSelection dataSelection, SharedQueue sharedQueue, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sourcesAndConverters, BdvOptions options) throws IOException {
        return N5Viewer.buildN5Sources(n5, N5Viewer.unwrapMultichannelSelections(dataSelection), sharedQueue, converterSetups, sourcesAndConverters, options);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends NumericType<T> & NativeType<T>, V extends Volatile<T>, M extends AxisMetadata & N5Metadata> int buildN5Sources(N5Reader n5, List<N5Metadata> selectedMetadata, SharedQueue sharedQueue, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sourcesAndConverters, BdvOptions options) throws IOException {
        int i;
        ArrayList additionalSources = new ArrayList();
        boolean is2D = true;
        int numTimepoints = 1;
        for (i = 0; i < selectedMetadata.size(); ++i) {
            void var11_11;
            MultiscaleDatasets msd;
            N5MultiScaleMetadata multiScaleDataset;
            String[] datasetsToOpen = null;
            Object var11_12 = null;
            N5Metadata metadata = selectedMetadata.get(i);
            String srcName = metadata.getName();
            if (metadata instanceof N5SingleScaleMetadata) {
                N5SingleScaleMetadata singleScaleDataset = (N5SingleScaleMetadata)metadata;
                String[] tmpDatasets = new String[]{singleScaleDataset.getPath()};
                AffineTransform3D[] tmpTransforms = new AffineTransform3D[]{singleScaleDataset.spatialTransform3d()};
                MultiscaleDatasets msd2 = MultiscaleDatasets.sort(tmpDatasets, tmpTransforms);
                datasetsToOpen = msd2.getPaths();
                AffineTransform3D[] affineTransform3DArray = msd2.getTransforms();
            } else if (metadata instanceof N5MultiScaleMetadata) {
                multiScaleDataset = (N5MultiScaleMetadata)metadata;
                datasetsToOpen = multiScaleDataset.getPaths();
                AffineTransform3D[] affineTransform3DArray = multiScaleDataset.spatialTransforms3d();
            } else if (metadata instanceof N5CosemMetadata) {
                N5CosemMetadata singleScaleCosemDataset = (N5CosemMetadata)metadata;
                datasetsToOpen = new String[]{singleScaleCosemDataset.getPath()};
                AffineTransform3D[] affineTransform3DArray = new AffineTransform3D[]{singleScaleCosemDataset.spatialTransform3d()};
            } else if (metadata instanceof CanonicalSpatialMetadata) {
                CanonicalSpatialMetadata canonicalDataset = (CanonicalSpatialMetadata)metadata;
                datasetsToOpen = new String[]{canonicalDataset.getPath()};
                AffineTransform3D[] affineTransform3DArray = new AffineTransform3D[]{canonicalDataset.getSpatialTransform().spatialTransform3d()};
            } else if (metadata instanceof OmeNgffMetadata) {
                multiScaleDataset = (OmeNgffMetadata)metadata;
                msd = MultiscaleDatasets.sort(multiScaleDataset.getPaths(), multiScaleDataset.spatialTransforms3d());
                datasetsToOpen = msd.getPaths();
                AffineTransform3D[] affineTransform3DArray = msd.getTransforms();
            } else if (metadata instanceof N5CosemMultiScaleMetadata) {
                multiScaleDataset = (N5CosemMultiScaleMetadata)metadata;
                msd = MultiscaleDatasets.sort(multiScaleDataset.getPaths(), multiScaleDataset.spatialTransforms3d());
                datasetsToOpen = msd.getPaths();
                AffineTransform3D[] affineTransform3DArray = msd.getTransforms();
            } else if (metadata instanceof CanonicalMultiscaleMetadata) {
                multiScaleDataset = (CanonicalMultiscaleMetadata)metadata;
                msd = MultiscaleDatasets.sort(multiScaleDataset.getPaths(), multiScaleDataset.spatialTransforms3d());
                datasetsToOpen = msd.getPaths();
                AffineTransform3D[] affineTransform3DArray = msd.getTransforms();
            } else if (metadata instanceof SpatialMetadata) {
                datasetsToOpen = new String[]{metadata.getPath()};
                AffineTransform3D[] affineTransform3DArray = new AffineTransform3D[]{((SpatialMetadata)metadata).spatialTransform3d()};
            } else if (metadata instanceof N5DatasetMetadata) {
                List<MetadataSource<?>> addTheseSources = MetadataSource.buildMetadataSources(n5, (N5DatasetMetadata)metadata);
                if (addTheseSources != null) {
                    additionalSources.addAll(addTheseSources);
                }
            } else {
                datasetsToOpen = new String[]{metadata.getPath()};
                AffineTransform3D[] affineTransform3DArray = new AffineTransform3D[]{new AffineTransform3D()};
            }
            if (datasetsToOpen == null || datasetsToOpen.length == 0) continue;
            RandomAccessibleInterval[] images = new RandomAccessibleInterval[datasetsToOpen.length];
            String unit = "pixel";
            for (int s = 0; s < images.length; ++s) {
                DefaultAxisMetadata axes;
                RandomAccessibleInterval<?> imagejImg;
                IntervalView img = N5Viewer.loadImage(n5, datasetsToOpen[s]);
                if (metadata instanceof AxisMetadata) {
                    imagejImg = AxisUtils.permuteForImagePlus(img, (AxisMetadata)((AxisMetadata)metadata));
                    unit = N5Viewer.unitFromAxes(((AxisMetadata)metadata).getAxes());
                } else if (metadata instanceof N5SingleScaleMetadata) {
                    axes = AxisUtils.defaultN5ViewerAxes((N5SpatialDatasetMetadata)((N5SingleScaleMetadata)metadata));
                    imagejImg = AxisUtils.permuteForImagePlus(img, (AxisMetadata)axes);
                    unit = ((N5SingleScaleMetadata)metadata).unit();
                } else if (N5Viewer.isN5ViewerMultiscale(metadata)) {
                    axes = AxisUtils.defaultN5ViewerAxes((N5SpatialDatasetMetadata)((N5SingleScaleMetadata[])((N5MultiScaleMetadata)metadata).getChildrenMetadata())[0]);
                    imagejImg = AxisUtils.permuteForImagePlus(img, (AxisMetadata)axes);
                    unit = N5Viewer.unitFromAxes(axes.getAxes());
                } else if (N5Viewer.isCosemMultiscale(metadata)) {
                    N5CosemMultiScaleMetadata cosemMulti = (N5CosemMultiScaleMetadata)metadata;
                    N5CosemMetadata cosemMeta = ((N5CosemMetadata[])cosemMulti.getChildrenMetadata())[0];
                    imagejImg = N5Viewer.permuteForImagePlus(img, (AffineTransform3D)var11_11[s], cosemMeta);
                    unit = cosemMeta.unit();
                } else {
                    NgffSingleScaleAxesMetadata ngffMeta = N5Viewer.isNgffMultiscale(metadata);
                    if (ngffMeta != null) {
                        imagejImg = N5Viewer.permuteForImagePlus(img, (AffineTransform3D)var11_11[s], ngffMeta);
                        unit = ngffMeta.unit();
                    } else {
                        IntervalView imgTmp = img;
                        while (imgTmp.numDimensions() < 5) {
                            imgTmp = Views.addDimension(imgTmp, (long)0L, (long)0L);
                        }
                        imagejImg = imgTmp;
                    }
                }
                images[s] = imagejImg;
                is2D &= imagejImg.dimension(3) == 1L;
                numTimepoints = (int)Math.max((long)numTimepoints, imagejImg.dimension(4));
            }
            NumericType type = (NumericType)Util.getTypeFromInterval((Interval)images[0]);
            double rx = var11_11[0].get(0, 0);
            double ry = var11_11[0].get(1, 1);
            double rz = var11_11[0].get(2, 2);
            List<Pair<Source<NumericType>, Source<V>>> sourcePairs = N5Viewer.createSource(type, srcName, images, (AffineTransform3D[])var11_11, sharedQueue, (VoxelDimensions)new FinalVoxelDimensions(unit, new double[]{rx, ry, rz}));
            for (Pair<Source<NumericType>, Source<V>> sourcePair : sourcePairs) {
                N5Viewer.addSourceToListsGenericType((Source)sourcePair.getA(), (Source)sourcePair.getB(), i + 1, converterSetups, sourcesAndConverters);
            }
        }
        for (MetadataSource metadataSource : additionalSources) {
            if (metadataSource.numTimePoints() > numTimepoints) {
                numTimepoints = metadataSource.numTimePoints();
            }
            N5Viewer.addSourceToListsGenericType(metadataSource, i + 1, converterSetups, sourcesAndConverters);
        }
        if (is2D) {
            options.is2D();
        }
        return numTimepoints;
    }

    protected static <T, M extends N5Metadata, A extends AxisMetadata & N5Metadata> RandomAccessibleInterval<T> permuteForImagePlus(RandomAccessibleInterval<T> img, AffineTransform3D transform, A meta) {
        int[] p = AxisUtils.findImagePlusPermutation(meta);
        AxisUtils.fillPermutation((int[])p);
        IntervalView imgTmp = img;
        while (imgTmp.numDimensions() < 5) {
            imgTmp = Views.addDimension(imgTmp, (long)0L, (long)0L);
        }
        if (AxisUtils.isIdentityPermutation((int[])p)) {
            return imgTmp;
        }
        int[] spatialPermutation = new int[]{p[0], p[1], p[3]};
        AffineGet permTform = AxisUtils.axisPermutationTransform((int[])spatialPermutation);
        transform.concatenate(permTform.inverse()).preConcatenate(permTform);
        return AxisUtils.permute((RandomAccessibleInterval)imgTmp, (int[])AxisUtils.invertPermutation((int[])p));
    }

    protected static <T extends NumericType<T> & NativeType<T>> RandomAccessibleInterval<?> loadImage(N5Reader n5, String dataset) {
        CachedCellImg img = N5Utils.openVolatile((N5Reader)n5, (String)dataset);
        Object t = Util.getTypeFromInterval((Interval)img);
        if (t instanceof LabelMultisetType) {
            CachedCellImg lmsImg = img;
            return N5Viewer.convertLabelMultisetCache(lmsImg);
        }
        if (OmeNgffMultiScaleMetadata.fOrder((DatasetAttributes)n5.getDatasetAttributes(dataset))) {
            return AxisUtils.reverseDimensions((RandomAccessibleInterval)img);
        }
        return img;
    }

    private static RandomAccessibleInterval<VolatileUnsignedLongType> convertLabelMultisetVolatile(CachedCellImg<LabelMultisetType, ?> lmsImg) {
        RandomAccessibleInterval vimg = VolatileViews.wrapAsVolatile(lmsImg);
        return Converters.convert2((RandomAccessibleInterval)vimg, (a, b) -> {
            b.set(((LabelMultisetType)a.get()).argMax());
            b.setValid(a.isValid());
        }, VolatileUnsignedLongType::new);
    }

    private static CachedCellImg<UnsignedLongType, ?> convertLabelMultisetLazy(CachedCellImg<LabelMultisetType, ?> lmsImg) {
        int[] cellDims = new int[lmsImg.numDimensions()];
        lmsImg.getCellGrid().cellDimensions(cellDims);
        return Lazy.generate(lmsImg, (int[])cellDims, (NativeType)new UnsignedLongType(), (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE), x -> {
            IntervalView in = Views.interval((RandomAccessible)lmsImg, (Interval)x);
            Cursor inc = in.cursor();
            Cursor outc = Views.flatIterable((RandomAccessibleInterval)x).cursor();
            while (outc.hasNext()) {
                ((UnsignedLongType)outc.next()).set(((LabelMultisetType)inc.next()).argMax());
            }
        });
    }

    private static CachedCellImg<UnsignedLongType, ?> convertLabelMultisetCache(CachedCellImg<LabelMultisetType, ?> lmsImg) {
        int[] cellDims = new int[lmsImg.numDimensions()];
        lmsImg.getCellGrid().cellDimensions(cellDims);
        return new ReadOnlyCachedCellImgFactory().create(lmsImg.dimensionsAsLongArray(), (NativeType)new UnsignedLongType(), out -> {
            IntervalView in = Views.interval((RandomAccessible)lmsImg, (Interval)out);
            Cursor inc = in.cursor();
            Cursor outc = out.cursor();
            while (outc.hasNext()) {
                ((UnsignedLongType)outc.next()).set(((LabelMultisetType)inc.next()).argMax());
            }
        }, (ReadOnlyCachedCellImgOptions)((ReadOnlyCachedCellImgOptions)new ReadOnlyCachedCellImgOptions().cellDimensions(cellDims)).volatileAccesses(true));
    }

    private static String unitFromAxes(Axis[] axes) {
        Optional<Axis> axisOpt = Arrays.stream(axes).filter(x -> x.getType().equals("space")).findFirst();
        if (axisOpt.isPresent()) {
            return axisOpt.get().getUnit();
        }
        return "pixel";
    }

    private static boolean isN5ViewerMultiscale(N5Metadata metadata) {
        N5MultiScaleMetadata ms;
        N5SingleScaleMetadata[] children;
        if (metadata instanceof N5MultiScaleMetadata && (children = (N5SingleScaleMetadata[])(ms = (N5MultiScaleMetadata)metadata).getChildrenMetadata()).length > 0) {
            return children[0] instanceof N5SingleScaleMetadata;
        }
        return false;
    }

    private static boolean isCosemMultiscale(N5Metadata metadata) {
        N5CosemMultiScaleMetadata ms;
        N5CosemMetadata[] children;
        if (metadata instanceof N5CosemMultiScaleMetadata && (children = (N5CosemMetadata[])(ms = (N5CosemMultiScaleMetadata)metadata).getChildrenMetadata()).length > 0) {
            return children[0] instanceof N5CosemMetadata;
        }
        return false;
    }

    private static NgffSingleScaleAxesMetadata isNgffMultiscale(N5Metadata metadata) {
        OmeNgffMultiScaleMetadata ms;
        NgffSingleScaleAxesMetadata[] children;
        if (metadata instanceof OmeNgffMetadata) {
            OmeNgffMetadata ngff = (OmeNgffMetadata)metadata;
            OmeNgffMultiScaleMetadata[] ms2 = ngff.multiscales;
            NgffSingleScaleAxesMetadata[] children2 = ms2[0].getChildrenMetadata();
            if (children2.length > 0 && children2[0] instanceof NgffSingleScaleAxesMetadata) {
                return children2[0];
            }
        } else if (metadata instanceof OmeNgffMultiScaleMetadata && (children = (ms = (OmeNgffMultiScaleMetadata)metadata).getChildrenMetadata()).length > 0 && children[0] instanceof NgffSingleScaleAxesMetadata) {
            return children[0];
        }
        return null;
    }

    private static <T extends NumericType<T> & NativeType<T>, V extends NumericType<V> & NativeType<V>> List<Pair<Source<T>, Source<V>>> createSource(T type, String srcName, RandomAccessibleInterval<T>[] images, AffineTransform3D[] transforms, SharedQueue sharedQueue, VoxelDimensions vd) {
        long nChannels = images[0].dimension(2);
        ArrayList<Pair<Source<T>, Source<V>>> sourcePairs = new ArrayList<Pair<Source<T>, Source<V>>>();
        int c = 0;
        while ((long)c < nChannels) {
            RandomAccessibleInterval[] channels = new RandomAccessibleInterval[images.length];
            for (int level = 0; level < images.length; ++level) {
                channels[level] = Views.hyperSlice(images[level], (int)2, (long)c);
            }
            RandomAccessibleIntervalMipmapSource4D source = new RandomAccessibleIntervalMipmapSource4D(channels, type, transforms, vd, srcName, true);
            ValuePair pair = new ValuePair((Object)source, (Object)source.asVolatile(sharedQueue));
            sourcePairs.add((Pair<Source<T>, Source<V>>)pair);
            ++c;
        }
        return sourcePairs;
    }

    private static <T extends NumericType<T> & NativeType<T>> void initCropController(BdvHandle bdv, List<? extends SourceAndConverter<T>> sourceAndConverers) {
        InputTriggerConfig config;
        TriggerBehaviourBindings bindings = bdv.getBdvHandle().getTriggerbindings();
        ViewerFrame viewerFrame = null;
        if (bdv instanceof BdvHandleFrame) {
            BdvHandleFrame bdvFrame = (BdvHandleFrame)bdv;
            config = bdvFrame.getBigDataViewer().getKeymapManager().getForwardSelectedKeymap().getConfig();
            viewerFrame = bdvFrame.getBigDataViewer().getViewerFrame();
        } else {
            config = new InputTriggerConfig();
        }
        Source src = sourceAndConverers.get(0).getSpimSource();
        double[] boxMin = new double[3];
        double[] boxMax = new double[3];
        RandomAccessibleInterval itvl = src.getSource(0, 0);
        itvl.realMin(boxMin);
        itvl.realMax(boxMax);
        AffineTransform3D srcXfm = new AffineTransform3D();
        src.getSourceTransform(0, 0, srcXfm);
        srcXfm.apply(boxMin, boxMin);
        srcXfm.apply(boxMax, boxMax);
        FinalRealInterval srcItvlWorld = new FinalRealInterval(boxMin, boxMax);
        BoxCrop cropController = new BoxCrop((AbstractViewerPanel)bdv.getViewerPanel(), bdv.getConverterSetups(), 0, config, bindings, BoxSelectionOptions.options(), new AffineTransform3D(), (RealInterval)srcItvlWorld, (RealInterval)srcItvlWorld, "crop", "SPACE");
        bindings.addBehaviourMap("crop", cropController.getBehaviourMap());
        bindings.addInputTriggerMap("crop", cropController.getInputTriggerMap(), new String[0]);
        List sources = sourceAndConverers.stream().map(SourceAndConverter::getSpimSource).collect(Collectors.toList());
        CropController cropControllerLegacy = new CropController(bdv.getViewerPanel(), sources, config, bdv.getKeybindings(), (KeyStrokeAdder.Factory)config);
        bindings.addBehaviourMap("cropLegacy", cropControllerLegacy.getBehaviourMap());
        bindings.addInputTriggerMap("cropLegacy", cropControllerLegacy.getInputTriggerMap(), new String[0]);
        if (viewerFrame != null) {
            InputActionBindings inputActionBindings = viewerFrame.getKeybindings();
            Actions actions = new Actions((KeyStrokeAdder.Factory)config, new String[]{"bdv"});
            actions.install(inputActionBindings, "crop");
            actions.runnableAction(() -> cropController.click(0, 0), "crop", new String[]{"SPACE"});
        }
    }

    private static <T> void addSourceToListsGenericType(Source<T> source, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        N5Viewer.addSourceToListsGenericType(source, null, setupId, converterSetups, sources);
    }

    private static <T, V extends Volatile<T>> void addSourceToListsGenericType(Source<T> source, Source<V> volatileSource, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        Object type = source.getType();
        if (!(type instanceof RealType || type instanceof ARGBType || type instanceof VolatileARGBType)) {
            throw new IllegalArgumentException("Unknown source type. Expected RealType, ARGBType, or VolatileARGBType");
        }
        N5Viewer.addSourceToListsNumericType(source, volatileSource, setupId, converterSetups, sources);
    }

    private static <T extends NumericType<T>, V extends Volatile<T>> void addSourceToListsNumericType(Source<T> source, Source<V> volatileSource, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        SourceAndConverter vsoc = volatileSource == null ? null : new SourceAndConverter(volatileSource, BigDataViewer.createConverterToARGB((NumericType)((NumericType)volatileSource.getType())));
        SourceAndConverter soc = new SourceAndConverter(source, BigDataViewer.createConverterToARGB((NumericType)((NumericType)source.getType())), vsoc);
        SourceAndConverter tsoc = BigDataViewer.wrapWithTransformedSource((SourceAndConverter)soc);
        converterSetups.add(BigDataViewer.createConverterSetup((SourceAndConverter)tsoc, (int)setupId));
        sources.add(tsoc);
    }
}

