/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Kalman_Filter
implements PlugIn {
    protected static ImagePlus imp;
    protected static ImagePlus imp2;
    protected static ImageStack stack;
    protected static ImageStack stack2;
    protected static ImageProcessor ip;
    protected static ImageProcessor ip2;
    private String fileName = null;
    private String directory = null;
    private String savedirectory = null;
    private String savename = null;
    private String abspath = null;
    private double numimages = 0.0;
    private double firstimage = 0.0;
    private String namewith = null;
    private String prefixname = null;
    private String[] fileList = null;
    private String[] fullDirectory = null;
    private static String[] filteredDirectory;
    private String newfileName = null;
    protected settingBar sbar = null;
    private double gain = 0.8;
    private double percentvar = 0.05;
    private double fps = 30.0;
    private boolean stopit = false;
    private boolean stop = true;
    private boolean save = false;
    private boolean test = true;

    public void run(String argv) {
        boolean g = true;
        boolean f = this.getFiles();
        if (f) {
            this.sbar = new settingBar();
            g = this.getStartSpecs();
            if (g) {
                imp = new ImagePlus(filteredDirectory[0]);
                imp2 = new ImagePlus(filteredDirectory[0]);
            }
        }
        if (f && g) {
            this.Kalmanizer();
        }
    }

    public boolean getFiles() {
        int i;
        String directory = "";
        JFileChooser jfc = new JFileChooser();
        jfc.setCurrentDirectory(new File("."));
        int jfcval = jfc.showDialog(this.sbar, "Choose File");
        if (jfcval == 0) {
            File thefile = jfc.getSelectedFile();
            this.fileName = thefile.getName();
            directory = thefile.getAbsolutePath();
            directory = directory.substring(0, directory.length() - this.fileName.length());
            this.prefixname = this.fileName.substring(0, this.fileName.length() - 4);
        }
        if (this.fileName == null) {
            return false;
        }
        GenericDialog fname = new GenericDialog("Pick the naming convention..", (Frame)IJ.getInstance());
        fname.addStringField("Enter the naming convention which is common to the files you wish to use", this.fileName, 40);
        fname.addStringField("Enter the naming convention for the save (will be appended with K######)", this.prefixname, 40);
        fname.addCheckbox("Specify save directory (the default is to save to the raw image directory)", false);
        fname.showDialog();
        if (fname.wasCanceled()) {
            return false;
        }
        this.namewith = fname.getNextString();
        this.savename = fname.getNextString();
        if (fname.getNextBoolean()) {
            JFileChooser dirchooser = new JFileChooser();
            dirchooser.setFileSelectionMode(1);
            int r = dirchooser.showDialog(this.sbar, "Choose Directory");
            try {
                this.savedirectory = dirchooser.getSelectedFile().getAbsolutePath();
            }
            catch (Exception e) {
                return false;
            }
        } else {
            this.savedirectory = directory;
        }
        this.namewith = directory + this.namewith;
        this.fullDirectory = new File(directory).list();
        for (int i2 = 0; i2 < this.fullDirectory.length; ++i2) {
            this.fullDirectory[i2] = directory + this.fullDirectory[i2];
        }
        StringSorter.sort((String[])this.fullDirectory);
        int j = 0;
        for (i = 0; i < this.fullDirectory.length; ++i) {
            if (!this.fullDirectory[i].startsWith(this.namewith)) continue;
            ++j;
        }
        filteredDirectory = new String[j];
        j = 0;
        for (i = 0; i < this.fullDirectory.length; ++i) {
            if (!this.fullDirectory[i].startsWith(this.namewith)) continue;
            Kalman_Filter.filteredDirectory[j] = this.fullDirectory[i];
            ++j;
        }
        this.newfileName = this.savedirectory + "\\" + this.savename + "K";
        return true;
    }

    public boolean getStartSpecs() {
        this.numimages = filteredDirectory.length;
        if (this.numimages == 0.0) {
            IJ.showMessage((String)"Improper Selection of Files");
            return false;
        }
        String ErrorMessage = new String("One of your values was not properly formatted.\nThe default values will be used.");
        GenericDialog finfo = new GenericDialog("Pick the files..", (Frame)IJ.getInstance());
        finfo.addNumericField("Enter the number of images (default is all)", this.numimages, 0);
        finfo.addNumericField("Enter the prediction bias", this.gain, 2);
        finfo.addNumericField("Enter the system noise estimate", this.percentvar, 2);
        finfo.addNumericField("Enter the frame per second rate", this.fps, 0);
        finfo.addCheckbox("Save the results?", this.save);
        finfo.showDialog();
        if (finfo.wasCanceled()) {
            return false;
        }
        this.numimages = finfo.getNextNumber();
        if (finfo.invalidNumber()) {
            IJ.showMessage((String)"Error", (String)"Invalid image number - Default employed");
            this.numimages = filteredDirectory.length;
        }
        this.gain = finfo.getNextNumber();
        if (finfo.invalidNumber()) {
            IJ.showMessage((String)"Error", (String)"Invalid gain number - Default employed");
            this.gain = 0.8;
        }
        this.percentvar = finfo.getNextNumber();
        if (finfo.invalidNumber()) {
            IJ.showMessage((String)"Error", (String)"Invalid variance - Default employed");
            this.percentvar = 0.05;
        }
        this.fps = finfo.getNextNumber();
        if (finfo.invalidNumber()) {
            IJ.showMessage((String)"Error", (String)"Invalid fps value - Default employed");
            this.fps = 30.0;
        }
        if (this.numimages > (double)filteredDirectory.length) {
            IJ.showMessage((String)"Error", (String)"Invalid image number. Default employed.");
            this.numimages = filteredDirectory.length;
        }
        if (this.percentvar > 1.0 || this.gain > 1.0 || this.percentvar <= 0.0 || this.gain < 0.0) {
            IJ.showMessage((String)ErrorMessage);
            this.percentvar = 0.05;
            this.gain = 0.8;
        }
        this.save = finfo.getNextBoolean();
        this.sbar.gainval.setText(String.valueOf(this.gain));
        this.sbar.fpsval.setText(String.valueOf((int)this.fps));
        this.sbar.gslider.setValue((int)(this.gain * 100.0));
        this.sbar.fpslider.setValue((int)this.fps);
        return true;
    }

    public void Kalmanizer() {
        int m = imp.getWidth();
        int n = imp.getHeight();
        int dimension = m * n;
        short[] stackslice = new short[dimension];
        short[] filteredslice = new short[dimension];
        double[] noisevar = new double[dimension];
        double[] average = new double[dimension];
        double[] predicted = new double[dimension];
        double[] predictedvar = new double[dimension];
        double[] observed = new double[dimension];
        double[] Kalman = new double[dimension];
        double[] corrected = new double[dimension];
        double[] correctedvar = new double[dimension];
        ImagePlus img = null;
        Opener o = new Opener();
        try {
            stack = imp.createEmptyStack();
        }
        catch (Exception e) {
            IJ.showMessage((String)("Improper File Type: " + this.fileName));
            return;
        }
        stack.addSlice("raw", imp.getProcessor());
        stack2 = imp.createEmptyStack();
        stack2.addSlice("Kalman Filter", imp.getProcessor());
        imp.setStack("raw", stack);
        imp.show();
        imp.getWindow().setLocation(20, 150);
        imp2.setStack("Kalman Filter", stack2);
        imp2.show();
        imp2.getWindow().setLocation(m + 50, 150);
        try {
            stackslice = (short[])stack.getPixels(1);
        }
        catch (Exception e) {
            IJ.showMessage((String)"KalmanFilter uses 16bit images");
            return;
        }
        stack.deleteLastSlice();
        stack2.deleteLastSlice();
        for (int i = 0; i < dimension; ++i) {
            noisevar[i] = this.percentvar;
        }
        while (this.stop) {
            Object[] options;
            int choice;
            predicted = this.short2double(stackslice);
            predictedvar = noisevar;
            long millis = 0L;
            this.stopit = false;
            int i = 0;
            while ((double)i < this.numimages) {
                int k;
                millis = (long)(1000.0 / this.fps);
                imp.setTitle("raw " + String.valueOf(i + 1) + "/" + String.valueOf((int)this.numimages));
                imp2.setTitle("Kalman Filter " + String.valueOf(i + 1) + "/" + String.valueOf((int)this.numimages));
                if (this.stopit) break;
                try {
                    Thread.sleep(millis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                img = o.openImage(filteredDirectory[i]);
                ip = img.getProcessor();
                stackslice = (short[])ip.getPixels();
                ip = imp.getProcessor();
                ip.setPixels((Object)stackslice);
                stack.addSlice(String.valueOf(i), ip);
                stackslice = (short[])stack.getPixels(1);
                imp.setStack(String.valueOf(i), stack);
                imp.setSlice(i);
                stack.deleteLastSlice();
                imp.setProcessor(null, ip);
                observed = this.short2double(stackslice);
                for (k = 0; k < Kalman.length; ++k) {
                    Kalman[k] = predictedvar[k] / (predictedvar[k] + noisevar[k]);
                }
                for (k = 0; k < corrected.length; ++k) {
                    corrected[k] = this.gain * predicted[k] + (1.0 - this.gain) * observed[k] + Kalman[k] * (observed[k] - predicted[k]);
                }
                for (k = 0; k < correctedvar.length; ++k) {
                    correctedvar[k] = predictedvar[k] * (1.0 - Kalman[k]);
                }
                predictedvar = correctedvar;
                predicted = corrected;
                filteredslice = this.double2short(corrected);
                ip2 = imp2.getProcessor();
                ip2.setPixels((Object)filteredslice);
                stack2.addSlice(String.valueOf(i), ip2);
                imp2.setStack(String.valueOf(i), stack2);
                imp2.setSlice(i);
                stack2.deleteLastSlice();
                if (this.save) {
                    String x = String.valueOf(i);
                    String s = "00000" + i;
                    String ss = s.substring(s.length() - 6);
                    new FileSaver(imp2).saveAsTiff(this.newfileName + ss + ".tif");
                }
                ++i;
            }
            if ((choice = JOptionPane.showOptionDialog(this.sbar, "How would you like to proceed?", "Kalman Filter", 1, 3, null, options = new Object[]{"Run again", "Run again and save", "Exit"}, options[0])) == 0) {
                this.stop = true;
                this.save = false;
            }
            if (choice == 1) {
                this.stop = true;
                this.save = true;
            }
            if (choice != 2) continue;
            this.stop = false;
            this.save = false;
        }
    }

    public short[] double2short(double[] array) {
        short[] shortarray = new short[array.length];
        for (int j = 0; j < array.length; ++j) {
            shortarray[j] = (short)(array[j] * 65535.0 - 32768.0);
        }
        return shortarray;
    }

    public double[] short2double(short[] array) {
        double[] doublearray = new double[array.length];
        for (int j = 0; j < array.length; ++j) {
            doublearray[j] = ((double)array[j] + 32768.0) / 65535.0;
        }
        return doublearray;
    }

    static {
        ip = null;
        ip2 = null;
        filteredDirectory = null;
    }

    class settingBar
    extends JFrame
    implements ActionListener {
        private JFrame frame = new JFrame();
        private JPanel panel1 = new JPanel();
        private JPanel panel2 = new JPanel();
        private Container cp = null;
        protected JLabel gainval = null;
        protected JLabel fpsval = null;
        private JButton stopper = null;
        protected JSlider gslider = null;
        protected JSlider fpslider = null;

        settingBar() {
            this.frame.setTitle("Kalman Filter");
            this.frame.setSize(400, 120);
            this.frame.setLocation(20, 20);
            this.cp = this.frame.getContentPane();
            this.cp.setLayout(new FlowLayout(0));
            this.stopper = new JButton("stop filter");
            this.stopper.addActionListener(this);
            this.gainval = new JLabel(String.valueOf(Kalman_Filter.this.gain), 4);
            this.fpsval = new JLabel(String.valueOf(Kalman_Filter.this.fps), 4);
            this.fpslider = new JSlider(1, 60, (int)Kalman_Filter.this.fps);
            this.fpslider.setPaintTicks(true);
            this.fpslider.setMajorTickSpacing(6);
            this.fpslider.setMinorTickSpacing(3);
            this.fpslider.addChangeListener(new fpsListener());
            this.panel1 = new JPanel();
            this.panel1.add(this.fpslider);
            this.panel1.add(new JLabel("fps"));
            this.panel1.add(this.fpsval);
            this.cp.add((Component)this.panel1, "North");
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            for (int i = 0; i <= 100; i += 20) {
                labelTable.put(new Integer(i), new JLabel(String.valueOf((double)i / 100.0)));
            }
            this.gslider = new JSlider(0, 100, (int)(Kalman_Filter.this.gain * 100.0));
            this.gslider.setLabelTable(labelTable);
            this.gslider.setPaintTicks(true);
            this.gslider.setPaintLabels(true);
            this.gslider.setMajorTickSpacing(20);
            this.gslider.setMinorTickSpacing(5);
            this.gslider.addChangeListener(new gainListener());
            this.panel2 = new JPanel();
            this.panel2.add(this.gslider);
            this.panel2.add(new JLabel("gain"));
            this.panel2.add(this.gainval);
            this.panel2.add(this.stopper);
            this.cp.add((Component)this.panel2, "South");
            this.frame.show();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == this.stopper) {
                Kalman_Filter.this.stopit = true;
            }
        }

        class fpsListener
        implements ChangeListener {
            JSlider source = null;

            fpsListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.source = (JSlider)e.getSource();
                Kalman_Filter.this.fps = this.source.getValue();
                settingBar.this.fpsval.setText(String.valueOf((int)Kalman_Filter.this.fps));
            }
        }

        class gainListener
        implements ChangeListener {
            JSlider source = null;

            gainListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.source = (JSlider)e.getSource();
                double gn = this.source.getValue();
                settingBar.this.gainval.setText(String.valueOf(gn /= 100.0));
                Kalman_Filter.this.gain = gn;
            }
        }
    }
}

