/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import levelsets.algorithm.DeferredArray3D;

public class DeferredObjectArray3D<T>
extends DeferredArray3D {
    final T defaultval;

    public DeferredObjectArray3D(int xdim, int ydim, int zdim, int tilesize, T defaultval) {
        super(xdim, ydim, zdim, tilesize);
        this.defaultval = defaultval;
    }

    public final void set(int x, int y, int z, T value) {
        Object[][][] tile = (Object[][][])this.getTile(x, y, z, true);
        tile[x % this.tilesize][y % this.tilesize][z % this.tilesize] = value;
    }

    public final T get(int x, int y, int z) {
        Object[][][] tile = (Object[][][])this.getTile(x, y, z, false);
        if (tile == null) {
            return this.defaultval;
        }
        return (T)tile[x % this.tilesize][y % this.tilesize][z % this.tilesize];
    }

    @Override
    public final String getAsString(int x, int y, int z) {
        return this.get(x, y, z).toString();
    }

    @Override
    protected Object createTile(int tilesize) {
        Object[][][] tile = new Object[tilesize][tilesize][tilesize];
        if (this.defaultval != null) {
            for (int x = 0; x < tile.length; ++x) {
                for (int y = 0; y < tile[0].length; ++y) {
                    for (int z = 0; z < tile[0][0].length; ++z) {
                        tile[x][y][z] = this.defaultval;
                    }
                }
            }
        }
        return tile;
    }
}

