/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.util.Collection;
import java.util.Set;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;

public class AnnotationHelper {
    private AnnotationHelper() {
    }

    public static void addMethodNamesToSet(Set<String> set, JRubyMethod jrubyMethod, String simpleName) {
        AnnotationHelper.addMethodNamesToSet(set, simpleName, jrubyMethod.name(), jrubyMethod.alias());
    }

    public static void addMethodNamesToSet(Collection<String> set, String simpleName, String[] names2, String[] aliases2) {
        if (names2.length == 0) {
            set.add(simpleName);
        } else {
            for (String name2 : names2) {
                set.add(name2);
            }
        }
        if (aliases2.length > 0) {
            for (String alias : aliases2) {
                set.add(alias);
            }
        }
    }

    public static int getArityValue(JRubyMethod anno, int actualRequired) {
        if (anno.optional() > 0 || anno.rest()) {
            return -(actualRequired + 1);
        }
        return actualRequired;
    }

    public static String getCallerCallConfigNameByAnno(JRubyMethod jrubyMethod) {
        boolean frame = false;
        boolean scope = false;
        for (FrameField field2 : jrubyMethod.reads()) {
            frame |= field2.needsFrame();
            scope |= field2.needsScope();
        }
        for (FrameField field2 : jrubyMethod.writes()) {
            frame |= field2.needsFrame();
            scope |= field2.needsScope();
        }
        return AnnotationHelper.getCallConfigName(frame, scope);
    }

    public static String getCallConfigName(boolean frame, boolean scope) {
        if (frame) {
            return scope ? "FrameFullScopeFull" : "FrameFullScopeNone";
        }
        return scope ? "FrameNoneScopeFull" : "FrameNoneScopeNone";
    }
}

