/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.DisplacementFieldTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.RealComposite;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractParametrizedFieldTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.RealCoordinateTransform;

public class DisplacementFieldCoordinateTransform<T extends RealType<T>>
extends AbstractParametrizedFieldTransform<DisplacementFieldTransform, T>
implements RealCoordinateTransform<DisplacementFieldTransform> {
    public static final transient String KEY = "displacements";
    protected transient DisplacementFieldTransform transform;
    protected transient int positionAxisIndex = 0;
    protected static final transient String vectorAxisType = "displacement";

    public DisplacementFieldCoordinateTransform(String name, RealRandomAccessible<RealComposite<T>> fields, String interpolation, String input, String output) {
        super(KEY, name, null, interpolation, input, output);
        this.buildTransform(fields);
    }

    public DisplacementFieldCoordinateTransform(String name, N5Reader n5, String path, String interpolation, String input, String output) {
        super(KEY, name, path, interpolation, input, output);
    }

    public DisplacementFieldCoordinateTransform(String name, String path, String interpolation, String input, String output) {
        super(KEY, name, path, interpolation, input, output);
    }

    public DisplacementFieldCoordinateTransform(String name, String path, String interpolation, String[] inputAxes, String[] outputAxes) {
        super(KEY, name, path, interpolation, inputAxes, outputAxes);
    }

    public DisplacementFieldCoordinateTransform(String name, String path, String interpolation) {
        this(name, path, interpolation, "", "");
    }

    @Override
    public int getVectorAxisIndex() {
        return this.positionAxisIndex;
    }

    @Override
    public DisplacementFieldTransform buildTransform(RealRandomAccessible<RealComposite<T>> field) {
        return new DisplacementFieldTransform(field);
    }

    @Override
    public DisplacementFieldTransform getTransform() {
        if (this.field != null && this.transform == null) {
            this.buildTransform(this.field);
        }
        return this.transform;
    }

    @Override
    public int parseVectorAxisIndex(N5Reader n5) {
        try {
            CoordinateSystem[] spaces = (CoordinateSystem[])n5.getAttribute(this.getParameterPath(), "coordinateSystems", CoordinateSystem[].class);
            if (spaces == null || spaces.length == 0) {
                return -1;
            }
            CoordinateSystem space = spaces[0];
            for (int i = 0; i < space.numDimensions(); ++i) {
                if (!space.getAxis(i).getType().equals(vectorAxisType)) continue;
                return i;
            }
        }
        catch (N5Exception n5Exception) {
            // empty catch block
        }
        return -1;
    }

    public static <T extends RealType<T> & NativeType<T>> DisplacementFieldCoordinateTransform<?> writeDisplacementFieldTransform(N5Writer n5, String dataset, RandomAccessibleInterval<T> posField, int[] blockSize, Compression compression, CoordinateSystem[] spaces, CoordinateTransform<?>[] transforms) {
        N5Utils.save(posField, (N5Writer)n5, (String)dataset, (int[])blockSize, (Compression)compression);
        n5.setAttribute(dataset, "coordinateSystems", (Object)spaces);
        n5.setAttribute(dataset, "coordinateTransformations", transforms);
        return null;
    }
}

