/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.filters;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.plugin.filter.Convolver;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Kuwahara
implements PlugInFilter {
    protected int imW;
    protected int imH;
    protected int kW;
    protected int kH;
    protected int nAngles = 30;
    protected int size = 11;
    protected boolean showKernels = false;
    public static final int VARIANCE = 0;
    public static final int VARIANCE_DIV_MEAN = 1;
    public static final int VARIANCE_DIV_MEAN_SQUARE = 2;
    private int criterionMethod = 1;

    public int setup(String arg, ImagePlus imp) {
        if (imp == null) {
            return 4096;
        }
        return 77;
    }

    public void run(ImageProcessor ipData) {
        if (!this.showDialog()) {
            return;
        }
        this.imW = ipData.getWidth();
        this.imH = ipData.getHeight();
        this.kW = this.size;
        this.kH = this.size;
        ImageStack imsKernels = this.createKernel(this.size, this.nAngles);
        this.filter(ipData, imsKernels);
    }

    public void setCriterionMethod(int criterion) {
        if (criterion >= 0 && criterion <= 2) {
            this.criterionMethod = criterion;
        }
    }

    public void setNumberOfAngles(int nAngles) {
        this.nAngles = nAngles;
    }

    public void setSize(int size) {
        if (size % 2 != 0) {
            this.size = size;
        }
    }

    public ImageStack createKernel(int size, int nAngles) {
        int y1;
        int nB = 3;
        int sizeTemp = size + 2 * nB;
        ImagePlus impLine = NewImage.createShortImage((String)"imLine", (int)sizeTemp, (int)sizeTemp, (int)1, (int)1);
        ImageProcessor ipLine = impLine.getProcessor();
        int x1 = (sizeTemp - 1) / 2;
        for (y1 = 0; y1 < sizeTemp; ++y1) {
            ipLine.putPixel(x1, y1, 1);
        }
        double rotationAngle = 180 / nAngles;
        ImagePlus impLineRotated = NewImage.createShortImage((String)"imLineRot", (int)sizeTemp, (int)sizeTemp, (int)1, (int)1);
        ImageProcessor ipLineRotated = impLineRotated.getProcessor();
        ImageStack imsKernel = new ImageStack(size, size);
        float[][] rotLineStack = new float[nAngles][size * size];
        for (int iAngle = 0; iAngle < nAngles; ++iAngle) {
            ipLineRotated.copyBits(ipLine, 0, 0, 0);
            ipLineRotated.rotate((double)iAngle * rotationAngle);
            int i = 0;
            for (x1 = nB; x1 < sizeTemp - nB; ++x1) {
                for (y1 = nB; y1 < sizeTemp - nB; ++y1) {
                    rotLineStack[iAngle][i] = ipLineRotated.getPixel(x1, y1);
                    ++i;
                }
            }
            imsKernel.addSlice("kernel", (Object)rotLineStack[iAngle]);
        }
        if (this.showKernels) {
            ImagePlus impKernel = new ImagePlus("Kernels", imsKernel);
            impKernel.show();
        }
        return imsKernel;
    }

    public void filter(ImageProcessor ipData, ImageStack imsKernels) {
        float[][] im = new float[this.imW][this.imH];
        float[][] imSquare = new float[this.imW][this.imH];
        float kernelSum = 0.0f;
        ipData.resetMinAndMax();
        float imMin = (float)ipData.getMin();
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                im[x1][y1] = ipData.getf(x1, y1) - imMin;
                imSquare[x1][y1] = im[x1][y1] * im[x1][y1];
            }
        }
        float[][] imSum = new float[this.imW][this.imH];
        float[][] imSumOfSquares = new float[this.imW][this.imH];
        float[][] value = new float[this.imW][this.imH];
        float[][] criterion = new float[this.imW][this.imH];
        float[][] result = new float[this.imW][this.imH];
        float[][] resultTemp = new float[this.imW][this.imH];
        float[][] resultCriterion = new float[this.imW][this.imH];
        float[][] resultCriterionTemp = new float[this.imW][this.imH];
        this.setFloatArray(result, 0.0f);
        this.setFloatArray(resultCriterion, Float.MAX_VALUE);
        int nKernels = imsKernels.getSize();
        for (int iKernel = 0; iKernel < nKernels; ++iKernel) {
            float[] pixelsKernel = (float[])imsKernels.getProcessor(iKernel + 1).getPixels();
            this.convolve2(im, imSquare, imSum, imSumOfSquares, pixelsKernel);
            kernelSum = this.kernelSum(pixelsKernel);
            if (this.criterionMethod == 0) {
                this.calculateCriterionVariance(imSum, imSumOfSquares, kernelSum, value, criterion);
            } else if (this.criterionMethod == 1) {
                this.calculateCriterionVarianceDivMean(imSum, imSumOfSquares, kernelSum, value, criterion);
            } else if (this.criterionMethod == 2) {
                this.calculateCriterionVarianceDivMean2(imSum, imSumOfSquares, kernelSum, value, criterion);
            }
            this.KuwaharaGM(value, criterion, pixelsKernel, resultTemp, resultCriterionTemp);
            this.setResultAndCriterion(result, resultTemp, resultCriterion, resultCriterionTemp);
            IJ.showProgress((int)(iKernel + 1), (int)nKernels);
        }
        this.putFloat2Image(ipData, result, imMin);
        ipData.resetMinAndMax();
    }

    void convolve2(float[][] im1, float[][] im2, float[][] im1Conv, float[][] im2Conv, float[] pixelsKernel) {
        int x1min = 0;
        int x1max = this.imW - 1;
        int y1min = 0;
        int y1max = this.imH - 1;
        float sum1 = 0.0f;
        float sum2 = 0.0f;
        int i = 0;
        for (int x1 = x1min; x1 <= x1max; ++x1) {
            for (int y1 = y1min; y1 <= y1max; ++y1) {
                int x2min = x1 - (this.kW - 1) / 2;
                int x2max = x1 + (this.kW - 1) / 2;
                int y2min = y1 - (this.kH - 1) / 2;
                int y2max = y1 + (this.kH - 1) / 2;
                sum1 = 0.0f;
                sum2 = 0.0f;
                i = 0;
                for (int y2 = y2min; y2 <= y2max; ++y2) {
                    for (int x2 = x2min; x2 <= x2max; ++x2) {
                        sum1 += this.getPixel(x2, y2, im1, this.imW, this.imH) * pixelsKernel[i];
                        sum2 += this.getPixel(x2, y2, im2, this.imW, this.imH) * pixelsKernel[i];
                        ++i;
                    }
                }
                im1Conv[x1][y1] = sum1;
                im2Conv[x1][y1] = sum2;
            }
        }
    }

    private float getPixel(int x, int y, float[][] pixels, int width, int height) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= width) {
            x = width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= height) {
            y = height - 1;
        }
        return pixels[x][y];
    }

    void convolve(ImageProcessor ip1, ImageProcessor ip2, float[] pixelsKernel) {
        Convolver c = new Convolver();
        boolean b = c.convolveFloat(ip1, pixelsKernel, this.size, this.size);
        if (!b) {
            IJ.error((String)"Error while convolving first image with kernel!");
            return;
        }
        Convolver c2 = new Convolver();
        b = c2.convolveFloat(ip2, pixelsKernel, this.size, this.size);
        if (!b) {
            IJ.error((String)"Error while convolving second image with kernel!");
            return;
        }
    }

    float kernelSum(float[] pixelsKernel) {
        float kernelSum = 0.0f;
        for (int i = 0; i < this.kW * this.kH; ++i) {
            kernelSum += pixelsKernel[i];
        }
        return kernelSum;
    }

    void KuwaharaGM(float[][] value, float[][] criterion, float[] pixelsKernel, float[][] result, float[][] resultCriterion) {
        int x1min = 0;
        int x1max = this.imW - 1;
        int y1min = 0;
        int y1max = this.imH - 1;
        for (int x1 = x1min; x1 <= x1max; ++x1) {
            for (int y1 = y1min; y1 <= y1max; ++y1) {
                int x2min = x1 - (this.kW - 1) / 2;
                int x2max = x1 + (this.kW - 1) / 2;
                int y2min = y1 - (this.kH - 1) / 2;
                int y2max = y1 + (this.kH - 1) / 2;
                int i = 0;
                int n = 0;
                float min = Float.MAX_VALUE;
                int x1minPos = x1;
                int y1minPos = y1;
                for (int y2 = y2min; y2 <= y2max; ++y2) {
                    for (int x2 = x2min; x2 <= x2max; ++x2) {
                        float criterionPixel;
                        int n2 = i++;
                        if (!(pixelsKernel[n2] > 0.0f) || !((criterionPixel = this.getPixel(x2, y2, criterion, this.imW, this.imH)) < min)) continue;
                        min = criterionPixel;
                        x1minPos = x2;
                        y1minPos = y2;
                        ++n;
                    }
                }
                result[x1][y1] = this.getPixel(x1minPos, y1minPos, value, this.imW, this.imH);
                resultCriterion[x1][y1] = min;
            }
        }
    }

    void setResultAndCriterion(float[][] result, float[][] resultTemp, float[][] resultCriterion, float[][] resultCriterionTemp) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                if (!(resultCriterionTemp[x1][y1] < resultCriterion[x1][y1])) continue;
                resultCriterion[x1][y1] = resultCriterionTemp[x1][y1];
                result[x1][y1] = resultTemp[x1][y1];
            }
        }
    }

    void setFloatArray(float[][] array, float val) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                array[x1][y1] = val;
            }
        }
    }

    public final void calculateCriterionVariance(float[][] imSum, float[][] imSumOfSquares, float kernelSum, float[][] value, float[][] criterion) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                value[x1][y1] = imSum[x1][y1] / kernelSum;
                criterion[x1][y1] = imSumOfSquares[x1][y1] / kernelSum - value[x1][y1] * value[x1][y1];
            }
        }
    }

    public final void calculateCriterionVarianceDivMean(float[][] imSum, float[][] imSumOfSquares, float kernelSum, float[][] value, float[][] criterion) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                value[x1][y1] = imSum[x1][y1] / kernelSum;
                criterion[x1][y1] = (imSumOfSquares[x1][y1] / kernelSum - value[x1][y1] * value[x1][y1]) / (value[x1][y1] + Float.MIN_VALUE);
            }
        }
    }

    public final void calculateCriterionVarianceDivMean2(float[][] imSum, float[][] imSumOfSquares, float kernelSum, float[][] value, float[][] criterion) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                value[x1][y1] = imSum[x1][y1] / kernelSum;
                criterion[x1][y1] = (imSumOfSquares[x1][y1] / kernelSum - value[x1][y1] * value[x1][y1]) / (value[x1][y1] * value[x1][y1] + Float.MIN_VALUE);
            }
        }
    }

    void putFloat2Image(ImageProcessor ip, float[][] imFloat, float imMin) {
        for (int x1 = 0; x1 < this.imW; ++x1) {
            for (int y1 = 0; y1 < this.imH; ++y1) {
                int x2 = x1;
                int y2 = y1;
                ip.setf(x1, y1, imFloat[x2][y2] + 0.5f + imMin);
            }
        }
    }

    boolean showDialog() {
        String[] criteria = new String[]{"Variance", "Variance / Mean", "Variance / Mean^2"};
        GenericDialog gd = new GenericDialog("Kuwahara Filter");
        gd.addNumericField("Number_of_angles", 30.0, 0);
        gd.addNumericField("Line_length", 11.0, 0);
        gd.addChoice("Criterion", criteria, criteria[0]);
        gd.addCheckbox("Show_kernels", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.nAngles = (int)gd.getNextNumber();
        this.size = (int)gd.getNextNumber();
        this.criterionMethod = gd.getNextChoiceIndex();
        this.showKernels = gd.getNextBoolean();
        if (this.size % 2 == 0) {
            IJ.error((String)"Line length must be odd!");
            return false;
        }
        return true;
    }

    public boolean applyFilter(ImageProcessor inputImage, int size, int nAngles, int criterion) {
        if (null == inputImage || size % 2 == 0) {
            return false;
        }
        this.imW = inputImage.getWidth();
        this.imH = inputImage.getHeight();
        this.size = this.kW = size;
        this.kH = size;
        this.nAngles = nAngles;
        this.criterionMethod = criterion;
        ImageStack imsKernels = this.createKernel(size, nAngles);
        this.filter(inputImage, imsKernels);
        return true;
    }
}

