/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.iotiming;

import java.util.concurrent.ConcurrentHashMap;
import net.imglib2.cache.iotiming.IoTimeBudget;
import net.imglib2.util.StopWatch;

public class IoStatistics {
    private final ConcurrentHashMap<Thread, StopWatch> perThreadStopWatches = new ConcurrentHashMap();
    private final StopWatch stopWatch = StopWatch.createStopped();
    private int numRunningThreads = 0;
    private long ioBytes = 0L;
    private final IoTimeBudget ioTimeBudget = new IoTimeBudget();

    public synchronized void start() {
        this.getThreadStopWatch().start();
        if (this.numRunningThreads++ == 0) {
            this.stopWatch.start();
        }
    }

    public synchronized void stop() {
        this.getThreadStopWatch().stop();
        if (--this.numRunningThreads == 0) {
            this.stopWatch.stop();
        }
    }

    public void incIoBytes(long n) {
        this.ioBytes += n;
    }

    public long getIoBytes() {
        return this.ioBytes;
    }

    public long getIoNanoTime() {
        return this.stopWatch.nanoTime();
    }

    public long getCumulativeIoNanoTime() {
        long sum = 0L;
        for (StopWatch w : this.perThreadStopWatches.values()) {
            sum += w.nanoTime();
        }
        return sum;
    }

    public IoTimeBudget getIoTimeBudget() {
        return this.ioTimeBudget;
    }

    private StopWatch getThreadStopWatch() {
        return this.perThreadStopWatches.computeIfAbsent(Thread.currentThread(), k -> StopWatch.createStopped());
    }
}

