/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.function.Consumer;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;

public interface Mutate2D
extends Structure2D,
Mutate1D {
    @Override
    default public void add(long index, double addend) {
        long tmpStructure = this.countRows();
        this.add(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), addend);
    }

    public void add(long var1, long var3, double var5);

    public void add(long var1, long var3, Number var5);

    @Override
    default public void add(long index, Number addend) {
        long tmpStructure = this.countRows();
        this.add(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), addend);
    }

    @Override
    default public void set(long index, double addend) {
        long tmpStructure = this.countRows();
        this.set(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), addend);
    }

    public void set(long var1, long var3, double var5);

    public void set(long var1, long var3, Number var5);

    @Override
    default public void set(long index, Number addend) {
        long tmpStructure = this.countRows();
        this.set(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), addend);
    }

    public static interface Receiver<N extends Number>
    extends Mutate2D,
    Fillable<N>,
    Consumer<Access2D<?>> {
        @Override
        default public void accept(Access2D<?> supplied) {
            if (!this.isAcceptable(supplied)) {
                throw new ProgrammingError("Not acceptable!");
            }
            supplied.loopAll((long r, long c) -> this.set(r, c, (Number)supplied.get(r, c)));
        }

        default public boolean isAcceptable(Structure2D supplier) {
            return this.countRows() >= supplier.countRows() && this.countColumns() >= supplier.countColumns();
        }
    }

    public static interface Modifiable<N extends Number>
    extends Structure2D,
    Mutate1D.Modifiable<N> {
        default public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            this.loopColumn(row, col, (r, c) -> this.modifyOne(r, c, modifier));
        }

        default public void modifyColumn(long col, UnaryFunction<N> modifier) {
            this.modifyColumn(0L, col, modifier);
        }

        default public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
            this.loopDiagonal(row, col, (r, c) -> this.modifyOne(r, c, modifier));
        }

        default public void modifyDiagonal(UnaryFunction<N> modifier) {
            this.modifyDiagonal(0L, 0L, modifier);
        }

        public void modifyOne(long var1, long var3, UnaryFunction<N> var5);

        @Override
        default public void modifyOne(long index, UnaryFunction<N> modifier) {
            long tmpStructure = this.countRows();
            this.modifyOne(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), modifier);
        }

        default public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            this.loopRow(row, col, (r, c) -> this.modifyOne(r, c, modifier));
        }

        default public void modifyRow(long row, UnaryFunction<N> modifier) {
            this.modifyRow(row, 0L, modifier);
        }
    }

    public static interface Mixable<N extends Number>
    extends Structure2D,
    Mutate1D.Mixable<N> {
        @Override
        default public double mix(long index, BinaryFunction<N> mixer, double addend) {
            long structure = this.countRows();
            return this.mix(Structure2D.row(index, structure), Structure2D.column(index, structure), mixer, (N)addend);
        }

        @Override
        default public N mix(long index, BinaryFunction<N> mixer, N addend) {
            long structure = this.countRows();
            return this.mix(Structure2D.row(index, structure), Structure2D.column(index, structure), mixer, addend);
        }

        public double mix(long var1, long var3, BinaryFunction<N> var5, double var6);

        public N mix(long var1, long var3, BinaryFunction<N> var5, N var6);
    }

    public static interface Fillable<N extends Number>
    extends Structure2D,
    Mutate1D.Fillable<N> {
        default public void fillColumn(long col, Access1D<N> values) {
            this.fillColumn(0L, col, (N)values);
        }

        default public void fillColumn(long row, long col, Access1D<N> values) {
            this.loopColumn(row, col, (r, c) -> this.fillOne(r, c, values.get(r - row)));
        }

        default public void fillColumn(long row, long col, N value) {
            this.loopColumn(row, col, (r, c) -> this.fillOne(r, c, value));
        }

        default public void fillColumn(long row, long col, NullaryFunction<N> supplier) {
            this.loopColumn(row, col, (r, c) -> this.fillOne(r, c, supplier));
        }

        default public void fillColumn(long col, N value) {
            this.fillColumn(0L, col, value);
        }

        default public void fillColumn(long col, NullaryFunction<N> supplier) {
            this.fillColumn(0L, col, supplier);
        }

        default public void fillDiagonal(Access1D<N> values) {
            this.fillDiagonal(0L, 0L, (N)values);
        }

        default public void fillDiagonal(long row, long col, Access1D<N> values) {
            this.loopDiagonal(row, col, (r, c) -> this.fillOne(r, c, values.get(r - row)));
        }

        default public void fillDiagonal(long row, long col, N value) {
            this.loopDiagonal(row, col, (r, c) -> this.fillOne(r, c, value));
        }

        default public void fillDiagonal(long row, long col, NullaryFunction<N> supplier) {
            this.loopDiagonal(row, col, (r, c) -> this.fillOne(r, c, supplier));
        }

        default public void fillDiagonal(N value) {
            this.fillDiagonal(0L, 0L, value);
        }

        default public void fillDiagonal(NullaryFunction<N> supplier) {
            this.fillDiagonal(0L, 0L, supplier);
        }

        @Override
        default public void fillOne(long index, Access1D<?> values, long valueIndex) {
            long tmpStructure = this.countRows();
            this.fillOne(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), values, valueIndex);
        }

        public void fillOne(long var1, long var3, Access1D<?> var5, long var6);

        public void fillOne(long var1, long var3, N var5);

        public void fillOne(long var1, long var3, NullaryFunction<N> var5);

        @Override
        default public void fillOne(long index, N value) {
            long tmpStructure = this.countRows();
            this.fillOne(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), value);
        }

        @Override
        default public void fillOne(long index, NullaryFunction<N> supplier) {
            long tmpStructure = this.countRows();
            this.fillOne(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), supplier);
        }

        default public void fillRow(long row, Access1D<N> values) {
            this.fillRow(row, 0L, (N)values);
        }

        default public void fillRow(long row, long col, Access1D<N> values) {
            this.loopRow(row, col, (r, c) -> this.fillOne(r, c, values.get(c - col)));
        }

        default public void fillRow(long row, long col, N value) {
            this.loopRow(row, col, (r, c) -> this.fillOne(r, c, value));
        }

        default public void fillRow(long row, long col, NullaryFunction<N> supplier) {
            this.loopRow(row, col, (r, c) -> this.fillOne(r, c, supplier));
        }

        default public void fillRow(long row, N value) {
            this.fillRow(row, 0L, value);
        }

        default public void fillRow(long row, NullaryFunction<N> supplier) {
            this.fillRow(row, 0L, supplier);
        }
    }

    public static interface Exchangeable
    extends Structure2D {
        public void exchangeColumns(long var1, long var3);

        public void exchangeRows(long var1, long var3);
    }

    public static interface BiModifiable<N extends Number>
    extends Structure2D,
    Mutate1D.BiModifiable<N> {
    }
}

