/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.access.Access1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConstrainedSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;

final class QPESolver
extends ConstrainedSolver {
    private boolean myFeasible = false;
    private final PrimitiveDenseStore myIterationX = (PrimitiveDenseStore)FACTORY.makeZero(this.countVariables(), 1L);

    QPESolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    private boolean isFeasible() {
        boolean retVal = true;
        MatrixStore<Double> tmpSE = this.getSE();
        int i = 0;
        while (retVal && (long)i < tmpSE.countRows()) {
            if (!this.options.feasibility.isZero(tmpSE.doubleValue(i))) {
                retVal = false;
            }
            ++i;
        }
        return retVal;
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        super.initialise(kickStarter);
        if (kickStarter != null && kickStarter.getState().isFeasible()) {
            this.getSolutionX().fillMatching(kickStarter);
            this.myFeasible = this.isFeasible();
            if (!this.myFeasible) {
                this.getSolutionX().fillAll(PrimitiveMath.ZERO);
            }
        } else {
            this.getSolutionX().fillAll(PrimitiveMath.ZERO);
            this.myFeasible = false;
        }
        return true;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return this.countIterations() < 1;
    }

    @Override
    protected void performIteration() {
        PrimitiveDenseStore tmpXL;
        MatrixStore<Double> tmpInvQAT;
        MatrixStore<MatrixStore<Double>> tmpS;
        this.getIterationQ();
        MatrixStore<Double> tmpIterC = this.getIterationC();
        MatrixStore<Double> tmpIterA = this.getIterationA();
        MatrixStore<Double> tmpIterB = this.getIterationB();
        boolean solved = false;
        PrimitiveDenseStore tmpIterX = this.myIterationX;
        PrimitiveDenseStore tmpIterL = (PrimitiveDenseStore)FACTORY.makeZero(tmpIterA.countRows(), 1L);
        if (tmpIterA.countRows() < tmpIterA.countColumns() && (solved = this.isSolvableQ()) && (solved = this.computeGeneral(tmpS = tmpIterA.multiply((Double)((Object)(tmpInvQAT = this.getSolutionQ(tmpIterA.transpose()))))))) {
            MatrixStore<Double> tmpInvQC = this.getSolutionQ(tmpIterC, tmpIterX);
            this.getSolutionGeneral(tmpIterA.multiply((Double)((Object)tmpInvQC)).subtract(tmpIterB), tmpIterL);
            this.getSolutionQ(tmpIterC.subtract(tmpIterA.transpose().multiply(tmpIterL)), tmpIterX);
        }
        if (!solved && (solved = this.solveFullKKT(tmpXL = (PrimitiveDenseStore)FACTORY.makeZero(this.countVariables() + this.countIterationConstraints(), 1L)))) {
            tmpIterX.fillMatching((Access1D<?>)tmpXL.logical().limits(this.countVariables(), 1).get());
            tmpIterL.fillMatching((Access1D<?>)tmpXL.logical().offsets(this.countVariables(), 0).get());
        }
        if (solved) {
            this.setState(Optimisation.State.OPTIMAL);
            if (this.myFeasible) {
                this.getSolutionX().modifyMatching(PrimitiveFunction.ADD, tmpIterX);
            } else {
                this.getSolutionX().fillMatching(tmpIterX);
            }
        } else if (this.myFeasible) {
            this.setState(Optimisation.State.FEASIBLE);
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
            this.getSolutionX().fillAll(PrimitiveMath.ZERO);
        }
    }

    @Override
    int countIterationConstraints() {
        return (int)this.getIterationA().countRows();
    }

    @Override
    final MatrixStore<Double> getIterationA() {
        return this.getMatrixAE();
    }

    @Override
    final MatrixStore<Double> getIterationB() {
        if (this.myFeasible) {
            return MatrixStore.PRIMITIVE.makeZero(this.countEqualityConstraints(), 1).get();
        }
        return this.getMatrixBE();
    }

    @Override
    final MatrixStore<Double> getIterationC() {
        if (this.myFeasible) {
            PhysicalStore<Double> mtrxQ = this.getMatrixQ();
            MatrixStore<Double> mtrxC = this.getMatrixC();
            PhysicalStore<Double> solX = this.getSolutionX();
            return mtrxC.subtract(mtrxQ.multiply((Double)((Object)solX)));
        }
        return this.getMatrixC();
    }
}

