/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.launcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.scijava.launcher.ClassLoaders;
import org.scijava.launcher.Java;
import org.scijava.launcher.Log;
import org.scijava.launcher.ReflectionUnlocker;
import org.scijava.launcher.Splash;

public class ClassLauncher {
    public static String appName() {
        return ClassLauncher.appName(null);
    }

    public static String appName(String fallback) {
        String appName = System.getProperty("scijava.app.name");
        return appName == null ? fallback : appName;
    }

    public static Path appDir() {
        Path appDirPath;
        String appDirValue = System.getProperty("scijava.app.directory");
        if (appDirValue != null && (appDirPath = Paths.get(appDirValue, new String[0]).normalize().toAbsolutePath()).toFile().exists()) {
            return appDirPath;
        }
        return null;
    }

    public static void main(String ... args) {
        if (Boolean.getBoolean("scijava.app.unlock-modules")) {
            ReflectionUnlocker.unlockAll();
        }
        ClassLauncher.tryToRun(Splash::show);
        ClassLauncher.tryToRun(Java::check);
        String appName = ClassLauncher.appName();
        appName = appName == null ? "" : " " + appName;
        Splash.update("Launching" + appName + "...");
        ClassLauncher.run(args);
    }

    private static void tryToRun(Runnable<?> r) {
        try {
            r.run();
        }
        catch (Throwable t) {
            Log.error(t);
        }
    }

    private static void run(String[] args) {
        int i;
        ClassLoader classLoader = null;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            String option;
            switch (option = args[i]) {
                default: 
            }
            ClassLauncher.error("Unknown option: " + option + "!");
            System.exit(1);
        }
        if (i >= args.length) {
            ClassLauncher.error("Missing argument: main class");
            System.exit(1);
        }
        String mainClass = args[i];
        args = ClassLauncher.slice(args, i + 1);
        ClassLauncher.debug("Launching main class " + mainClass + " with parameters " + Arrays.toString(args));
        try {
            ClassLauncher.launch(classLoader, mainClass, args);
        }
        catch (Throwable t) {
            Log.error(t);
            System.exit(1);
        }
    }

    private static String[] slice(String[] array, int from) {
        return ClassLauncher.slice(array, from, array.length);
    }

    private static String[] slice(String[] array, int from, int to) {
        String[] result = new String[to - from];
        if (result.length > 0) {
            System.arraycopy(array, from, result, 0, result.length);
        }
        return result;
    }

    private static void debug(String message) {
        Log.debug("[ClassLauncher] " + message);
    }

    private static void error(String message) {
        Log.error("[ClassLauncher] " + message);
    }

    static void launch(ClassLoader classLoader, String className, String ... args) {
        Class<?> main = null;
        ClassLauncher.debug("Class loader = " + classLoader);
        try {
            main = ClassLoaders.loadClass(classLoader, className);
        }
        catch (ClassNotFoundException e) {
            Log.error(e);
            System.exit(1);
        }
        catch (UnsupportedClassVersionError e) {
            Log.debug(e);
            Java.informAndMaybeUpgrade(e);
            System.exit(1);
        }
        Method mainMethod = null;
        try {
            mainMethod = main.getMethod("main", args.getClass());
        }
        catch (NoSuchMethodException e) {
            Log.debug(e);
            ClassLauncher.error("Class '" + className + "' does not have a main method.");
            System.exit(1);
        }
        Integer result = 1;
        try {
            result = (Integer)mainMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            Log.debug(e);
            ClassLauncher.error("The main method of class '" + className + "' is not public.");
        }
        catch (InvocationTargetException e) {
            ClassLauncher.error("Error while executing the main method of class '" + className + "':");
            Log.error(e.getTargetException());
        }
        if (result != null) {
            System.exit(result);
        }
    }

    private static interface Runnable<E extends Throwable> {
        public void run() throws E;
    }
}

