/*
 * Decompiled with CFR 0.152.
 */
package io.scif.jj2000.j2k.image.forwcomptransf;

import io.scif.jj2000.j2k.image.BlkImgDataSrc;
import io.scif.jj2000.j2k.image.CompTransfSpec;
import io.scif.jj2000.j2k.image.DataBlk;
import io.scif.jj2000.j2k.image.DataBlkFloat;
import io.scif.jj2000.j2k.image.DataBlkInt;
import io.scif.jj2000.j2k.image.ImgDataAdapter;
import io.scif.jj2000.j2k.util.MathUtil;
import io.scif.jj2000.j2k.wavelet.analysis.AnWTFilterSpec;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;

public class ForwCompTransf
extends ImgDataAdapter
implements BlkImgDataSrc {
    public static final int NONE = 0;
    public static final int FORW_RCT = 1;
    public static final int FORW_ICT = 2;
    private BlkImgDataSrc src;
    private CompTransfSpec cts;
    private AnWTFilterSpec wfs;
    private int transfType = 0;
    private int[] tdepth;
    private DataBlk outBlk;
    private DataBlkInt block0;
    private DataBlkInt block1;
    private DataBlkInt block2;
    public static final char OPT_PREFIX = 'M';
    private static final String[][] pinfo = new String[][]{{"Mct", "[<tile index>] [true|false] ...", "Specifies to use component transformation with some tiles.  If the wavelet transform is reversible (w5x3 filter), the Reversible Component Transformation (RCT) is applied. If not (w9x7 filter), the Irreversible Component Transformation (ICT) is used.", null}};

    public ForwCompTransf(BlkImgDataSrc imgSrc, J2KImageWriteParamJava wp) {
        super(imgSrc);
        this.cts = wp.getComponentTransformation();
        this.wfs = wp.getFilters();
        this.src = imgSrc;
    }

    public int getFixedPoint(int c) {
        return this.src.getFixedPoint(c);
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public static int[] calcMixedBitDepths(int[] ntdepth, int ttype, int[] tdepth) {
        if (ntdepth.length < 3 && ttype != 0) {
            throw new IllegalArgumentException();
        }
        if (tdepth == null) {
            tdepth = new int[ntdepth.length];
        }
        switch (ttype) {
            case 0: {
                System.arraycopy(ntdepth, 0, tdepth, 0, ntdepth.length);
                break;
            }
            case 1: {
                if (ntdepth.length > 3) {
                    System.arraycopy(ntdepth, 3, tdepth, 3, ntdepth.length - 3);
                }
                tdepth[0] = MathUtil.log2((1 << ntdepth[0]) + (2 << ntdepth[1]) + (1 << ntdepth[2]) - 1) - 2 + 1;
                tdepth[1] = MathUtil.log2((1 << ntdepth[2]) + (1 << ntdepth[1]) - 1) + 1;
                tdepth[2] = MathUtil.log2((1 << ntdepth[0]) + (1 << ntdepth[1]) - 1) + 1;
                break;
            }
            case 2: {
                if (ntdepth.length > 3) {
                    System.arraycopy(ntdepth, 3, tdepth, 3, ntdepth.length - 3);
                }
                tdepth[0] = MathUtil.log2((int)Math.floor((double)(1 << ntdepth[0]) * 0.299072 + (double)(1 << ntdepth[1]) * 0.586914 + (double)(1 << ntdepth[2]) * 0.114014) - 1) + 1;
                tdepth[1] = MathUtil.log2((int)Math.floor((double)(1 << ntdepth[0]) * 0.168701 + (double)(1 << ntdepth[1]) * 0.331299 + (double)(1 << ntdepth[2]) * 0.5) - 1) + 1;
                tdepth[2] = MathUtil.log2((int)Math.floor((double)(1 << ntdepth[0]) * 0.5 + (double)(1 << ntdepth[1]) * 0.418701 + (double)(1 << ntdepth[2]) * 0.081299) - 1) + 1;
            }
        }
        return tdepth;
    }

    private void initForwRCT() {
        int tIdx = this.getTileIdx();
        if (this.src.getNumComps() < 3) {
            throw new IllegalArgumentException();
        }
        if (this.src.getTileCompWidth(tIdx, 0) != this.src.getTileCompWidth(tIdx, 1) || this.src.getTileCompWidth(tIdx, 0) != this.src.getTileCompWidth(tIdx, 2) || this.src.getTileCompHeight(tIdx, 0) != this.src.getTileCompHeight(tIdx, 1) || this.src.getTileCompHeight(tIdx, 0) != this.src.getTileCompHeight(tIdx, 2)) {
            throw new IllegalArgumentException("Can not use RCT on components with different dimensions");
        }
        int[] utd = new int[this.src.getNumComps()];
        for (int i = utd.length - 1; i >= 0; --i) {
            utd[i] = this.src.getNomRangeBits(i);
        }
        this.tdepth = ForwCompTransf.calcMixedBitDepths(utd, 1, null);
    }

    private void initForwICT() {
        int tIdx = this.getTileIdx();
        if (this.src.getNumComps() < 3) {
            throw new IllegalArgumentException();
        }
        if (this.src.getTileCompWidth(tIdx, 0) != this.src.getTileCompWidth(tIdx, 1) || this.src.getTileCompWidth(tIdx, 0) != this.src.getTileCompWidth(tIdx, 2) || this.src.getTileCompHeight(tIdx, 0) != this.src.getTileCompHeight(tIdx, 1) || this.src.getTileCompHeight(tIdx, 0) != this.src.getTileCompHeight(tIdx, 2)) {
            throw new IllegalArgumentException("Can not use ICT on components with different dimensions");
        }
        int[] utd = new int[this.src.getNumComps()];
        for (int i = utd.length - 1; i >= 0; --i) {
            utd[i] = this.src.getNomRangeBits(i);
        }
        this.tdepth = ForwCompTransf.calcMixedBitDepths(utd, 2, null);
    }

    public String toString() {
        switch (this.transfType) {
            case 1: {
                return "Forward RCT";
            }
            case 2: {
                return "Forward ICT";
            }
            case 0: {
                return "No component transformation";
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation");
    }

    public int getNomRangeBits(int c) {
        switch (this.transfType) {
            case 1: 
            case 2: {
                return this.tdepth[c];
            }
            case 0: {
                return this.src.getNomRangeBits(c);
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation");
    }

    public boolean isReversible() {
        switch (this.transfType) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation");
    }

    public DataBlk getCompData(DataBlk blk, int c) {
        if (c >= 3 || this.transfType == 0) {
            return this.src.getCompData(blk, c);
        }
        return this.getInternCompData(blk, c);
    }

    public DataBlk getInternCompData(DataBlk blk, int c) {
        switch (this.transfType) {
            case 0: {
                return this.src.getInternCompData(blk, c);
            }
            case 1: {
                return this.forwRCT(blk, c);
            }
            case 2: {
                return this.forwICT(blk, c);
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation for tile: " + this.tIdx);
    }

    private DataBlk forwRCT(DataBlk blk, int c) {
        int w = blk.w;
        int h = blk.h;
        if (c >= 0 && c <= 2) {
            int[] outdata;
            if (blk.getDataType() != 3) {
                if (this.outBlk == null || this.outBlk.getDataType() != 3) {
                    this.outBlk = new DataBlkInt();
                }
                this.outBlk.w = w;
                this.outBlk.h = h;
                this.outBlk.ulx = blk.ulx;
                this.outBlk.uly = blk.uly;
                blk = this.outBlk;
            }
            if ((outdata = (int[])blk.getData()) == null || outdata.length < h * w) {
                outdata = new int[h * w];
                blk.setData(outdata);
            }
            if (this.block0 == null) {
                this.block0 = new DataBlkInt();
            }
            if (this.block1 == null) {
                this.block1 = new DataBlkInt();
            }
            if (this.block2 == null) {
                this.block2 = new DataBlkInt();
            }
            this.block1.w = this.block2.w = blk.w;
            this.block0.w = this.block2.w;
            this.block1.h = this.block2.h = blk.h;
            this.block0.h = this.block2.h;
            this.block1.ulx = this.block2.ulx = blk.ulx;
            this.block0.ulx = this.block2.ulx;
            this.block1.uly = this.block2.uly = blk.uly;
            this.block0.uly = this.block2.uly;
            this.block0 = (DataBlkInt)this.src.getInternCompData(this.block0, 0);
            int[] data0 = (int[])this.block0.getData();
            this.block1 = (DataBlkInt)this.src.getInternCompData(this.block1, 1);
            int[] data1 = (int[])this.block1.getData();
            this.block2 = (DataBlkInt)this.src.getInternCompData(this.block2, 2);
            int[] bdata = (int[])this.block2.getData();
            blk.progressive = this.block0.progressive || this.block1.progressive || this.block2.progressive;
            blk.offset = 0;
            blk.scanw = w;
            int k = w * h - 1;
            int k0 = this.block0.offset + (h - 1) * this.block0.scanw + w - 1;
            int k1 = this.block1.offset + (h - 1) * this.block1.scanw + w - 1;
            int k2 = this.block2.offset + (h - 1) * this.block2.scanw + w - 1;
            switch (c) {
                case 0: {
                    for (int i = h - 1; i >= 0; --i) {
                        int mink = k - w;
                        while (k > mink) {
                            outdata[k] = data0[k] + 2 * data1[k] + bdata[k] >> 2;
                            --k;
                            --k0;
                            --k1;
                            --k2;
                        }
                        k0 -= this.block0.scanw - w;
                        k1 -= this.block1.scanw - w;
                        k2 -= this.block2.scanw - w;
                    }
                    break;
                }
                case 1: {
                    for (int i = h - 1; i >= 0; --i) {
                        int mink = k - w;
                        while (k > mink) {
                            outdata[k] = bdata[k2] - data1[k1];
                            --k;
                            --k1;
                            --k2;
                        }
                        k1 -= this.block1.scanw - w;
                        k2 -= this.block2.scanw - w;
                    }
                    break;
                }
                case 2: {
                    for (int i = h - 1; i >= 0; --i) {
                        int mink = k - w;
                        while (k > mink) {
                            outdata[k] = data0[k0] - data1[k1];
                            --k;
                            --k0;
                            --k1;
                        }
                        k0 -= this.block0.scanw - w;
                        k1 -= this.block1.scanw - w;
                    }
                    break;
                }
            }
        } else {
            if (c >= 3) {
                return this.src.getInternCompData(blk, c);
            }
            throw new IllegalArgumentException();
        }
        return blk;
    }

    private DataBlk forwICT(DataBlk blk, int c) {
        float[] outdata;
        int w = blk.w;
        int h = blk.h;
        if (blk.getDataType() != 4) {
            if (this.outBlk == null || this.outBlk.getDataType() != 4) {
                this.outBlk = new DataBlkFloat();
            }
            this.outBlk.w = w;
            this.outBlk.h = h;
            this.outBlk.ulx = blk.ulx;
            this.outBlk.uly = blk.uly;
            blk = this.outBlk;
        }
        if ((outdata = (float[])blk.getData()) == null || outdata.length < w * h) {
            outdata = new float[h * w];
            blk.setData(outdata);
        }
        if (c >= 0 && c <= 2) {
            if (this.block0 == null) {
                this.block0 = new DataBlkInt();
            }
            if (this.block1 == null) {
                this.block1 = new DataBlkInt();
            }
            if (this.block2 == null) {
                this.block2 = new DataBlkInt();
            }
            this.block1.w = this.block2.w = blk.w;
            this.block0.w = this.block2.w;
            this.block1.h = this.block2.h = blk.h;
            this.block0.h = this.block2.h;
            this.block1.ulx = this.block2.ulx = blk.ulx;
            this.block0.ulx = this.block2.ulx;
            this.block1.uly = this.block2.uly = blk.uly;
            this.block0.uly = this.block2.uly;
            this.block0 = (DataBlkInt)this.src.getInternCompData(this.block0, 0);
            int[] data0 = (int[])this.block0.getData();
            this.block1 = (DataBlkInt)this.src.getInternCompData(this.block1, 1);
            int[] data1 = (int[])this.block1.getData();
            this.block2 = (DataBlkInt)this.src.getInternCompData(this.block2, 2);
            int[] data2 = (int[])this.block2.getData();
            blk.progressive = this.block0.progressive || this.block1.progressive || this.block2.progressive;
            blk.offset = 0;
            blk.scanw = w;
            int k = w * h - 1;
            int k0 = this.block0.offset + (h - 1) * this.block0.scanw + w - 1;
            int k1 = this.block1.offset + (h - 1) * this.block1.scanw + w - 1;
            int k2 = this.block2.offset + (h - 1) * this.block2.scanw + w - 1;
            switch (c) {
                case 0: {
                    for (int i = h - 1; i >= 0; --i) {
                        int mink = k - w;
                        while (k > mink) {
                            outdata[k] = 0.299f * (float)data0[k0] + 0.587f * (float)data1[k1] + 0.114f * (float)data2[k2];
                            --k;
                            --k0;
                            --k1;
                            --k2;
                        }
                        k0 -= this.block0.scanw - w;
                        k1 -= this.block1.scanw - w;
                        k2 -= this.block2.scanw - w;
                    }
                    break;
                }
                case 1: {
                    for (int i = h - 1; i >= 0; --i) {
                        int mink = k - w;
                        while (k > mink) {
                            outdata[k] = -0.16875f * (float)data0[k0] - 0.33126f * (float)data1[k1] + 0.5f * (float)data2[k2];
                            --k;
                            --k0;
                            --k1;
                            --k2;
                        }
                        k0 -= this.block0.scanw - w;
                        k1 -= this.block1.scanw - w;
                        k2 -= this.block2.scanw - w;
                    }
                    break;
                }
                case 2: {
                    for (int i = h - 1; i >= 0; --i) {
                        int mink = k - w;
                        while (k > mink) {
                            outdata[k] = 0.5f * (float)data0[k0] - 0.41869f * (float)data1[k1] - 0.08131f * (float)data2[k2];
                            --k;
                            --k0;
                            --k1;
                            --k2;
                        }
                        k0 -= this.block0.scanw - w;
                        k1 -= this.block1.scanw - w;
                        k2 -= this.block2.scanw - w;
                    }
                    break;
                }
            }
        } else {
            if (c >= 3) {
                DataBlkInt indb = new DataBlkInt(blk.ulx, blk.uly, w, h);
                this.src.getInternCompData(indb, c);
                int[] indata = (int[])indb.getData();
                int k = w * h - 1;
                int k0 = indb.offset + (h - 1) * indb.scanw + w - 1;
                for (int i = h - 1; i >= 0; --i) {
                    int mink = k - w;
                    while (k > mink) {
                        outdata[k] = indata[k0];
                        --k;
                        --k0;
                    }
                    k0 += indb.w - w;
                }
                blk.progressive = indb.progressive;
                blk.offset = 0;
                blk.scanw = w;
                return blk;
            }
            throw new IllegalArgumentException();
        }
        return blk;
    }

    public void setTile(int x, int y) {
        this.src.setTile(x, y);
        this.tIdx = this.getTileIdx();
        String str = (String)this.cts.getTileDef(this.tIdx);
        if (str.equals("none")) {
            this.transfType = 0;
        } else if (str.equals("rct")) {
            this.transfType = 1;
            this.initForwRCT();
        } else if (str.equals("ict")) {
            this.transfType = 2;
            this.initForwICT();
        } else {
            throw new IllegalArgumentException("Component transformation not recognized");
        }
    }

    public void nextTile() {
        this.src.nextTile();
        this.tIdx = this.getTileIdx();
        String str = (String)this.cts.getTileDef(this.tIdx);
        if (str.equals("none")) {
            this.transfType = 0;
        } else if (str.equals("rct")) {
            this.transfType = 1;
            this.initForwRCT();
        } else if (str.equals("ict")) {
            this.transfType = 2;
            this.initForwICT();
        } else {
            throw new IllegalArgumentException("Component transformation not recognized");
        }
    }
}

