/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.janelia.saalfeldlab.n5.ByteArrayDataBlock;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DoubleArrayDataBlock;
import org.janelia.saalfeldlab.n5.FloatArrayDataBlock;
import org.janelia.saalfeldlab.n5.IntArrayDataBlock;
import org.janelia.saalfeldlab.n5.LongArrayDataBlock;
import org.janelia.saalfeldlab.n5.ShortArrayDataBlock;
import org.janelia.saalfeldlab.n5.StringDataBlock;

public enum DataType {
    UINT8("uint8", (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements])),
    UINT16("uint16", (blockSize, gridPosition, numElements) -> new ShortArrayDataBlock(blockSize, gridPosition, new short[numElements])),
    UINT32("uint32", (blockSize, gridPosition, numElements) -> new IntArrayDataBlock(blockSize, gridPosition, new int[numElements])),
    UINT64("uint64", (blockSize, gridPosition, numElements) -> new LongArrayDataBlock(blockSize, gridPosition, new long[numElements])),
    INT8("int8", (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements])),
    INT16("int16", (blockSize, gridPosition, numElements) -> new ShortArrayDataBlock(blockSize, gridPosition, new short[numElements])),
    INT32("int32", (blockSize, gridPosition, numElements) -> new IntArrayDataBlock(blockSize, gridPosition, new int[numElements])),
    INT64("int64", (blockSize, gridPosition, numElements) -> new LongArrayDataBlock(blockSize, gridPosition, new long[numElements])),
    FLOAT32("float32", (blockSize, gridPosition, numElements) -> new FloatArrayDataBlock(blockSize, gridPosition, new float[numElements])),
    FLOAT64("float64", (blockSize, gridPosition, numElements) -> new DoubleArrayDataBlock(blockSize, gridPosition, new double[numElements])),
    STRING("string", (blockSize, gridPosition, numElements) -> new StringDataBlock(blockSize, gridPosition, new byte[numElements])),
    OBJECT("object", (blockSize, gridPosition, numElements) -> new ByteArrayDataBlock(blockSize, gridPosition, new byte[numElements]));

    private final String label;
    private final DataBlockFactory dataBlockFactory;

    private DataType(String label, DataBlockFactory dataBlockFactory) {
        this.label = label;
        this.dataBlockFactory = dataBlockFactory;
    }

    public String toString() {
        return this.label;
    }

    public static DataType fromString(String string) {
        for (DataType value : DataType.values()) {
            if (!value.toString().equals(string)) continue;
            return value;
        }
        return null;
    }

    public DataBlock<?> createDataBlock(int[] blockSize, long[] gridPosition, int numElements) {
        return this.dataBlockFactory.createDataBlock(blockSize, gridPosition, numElements);
    }

    public DataBlock<?> createDataBlock(int[] blockSize, long[] gridPosition) {
        return this.dataBlockFactory.createDataBlock(blockSize, gridPosition, DataBlock.getNumElements(blockSize));
    }

    public static class JsonAdapter
    implements JsonDeserializer<DataType>,
    JsonSerializer<DataType> {
        @Override
        public DataType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return DataType.fromString(json.getAsString());
        }

        @Override
        public JsonElement serialize(DataType src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }

    private static interface DataBlockFactory {
        public DataBlock<?> createDataBlock(int[] var1, long[] var2, int var3);
    }
}

