/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.janelia.saalfeldlab.n5.ByteArrayDataBlock;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;

public interface N5Writer
extends N5Reader {
    default public <T> void setAttribute(String groupPath, String attributePath, T attribute) throws N5Exception {
        this.setAttributes(groupPath, Collections.singletonMap(attributePath, attribute));
    }

    public void setAttributes(String var1, Map<String, ?> var2) throws N5Exception;

    public boolean removeAttribute(String var1, String var2) throws N5Exception;

    public <T> T removeAttribute(String var1, String var2, Class<T> var3) throws N5Exception;

    default public boolean removeAttributes(String groupPath, List<String> attributePaths) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(groupPath);
        boolean removed = false;
        for (String attribute : attributePaths) {
            removed |= this.removeAttribute(normalPath, N5URI.normalizeAttributePath(attribute));
        }
        return removed;
    }

    default public void setDatasetAttributes(String datasetPath, DatasetAttributes datasetAttributes) throws N5Exception {
        this.setAttributes(datasetPath, datasetAttributes.asMap());
    }

    default public void setVersion() throws N5Exception {
        if (!VERSION.equals(this.getVersion())) {
            this.setAttribute("/", "n5", VERSION.toString());
        }
    }

    public void createGroup(String var1) throws N5Exception;

    public boolean remove(String var1) throws N5Exception;

    default public boolean remove() throws N5Exception {
        return this.remove("/");
    }

    default public void createDataset(String datasetPath, DatasetAttributes datasetAttributes) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(datasetPath);
        this.createGroup(normalPath);
        this.setDatasetAttributes(normalPath, datasetAttributes);
    }

    default public void createDataset(String datasetPath, long[] dimensions, int[] blockSize, DataType dataType, Compression compression) throws N5Exception {
        this.createDataset(datasetPath, new DatasetAttributes(dimensions, blockSize, dataType, compression));
    }

    public <T> void writeBlock(String var1, DatasetAttributes var2, DataBlock<T> var3) throws N5Exception;

    public boolean deleteBlock(String var1, long ... var2) throws N5Exception;

    default public void writeSerializedBlock(Serializable object, String datasetPath, DatasetAttributes datasetAttributes, long ... gridPosition) throws N5Exception {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteOutputStream);){
            out.writeObject(object);
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException(e);
        }
        byte[] bytes = byteOutputStream.toByteArray();
        ByteArrayDataBlock dataBlock = new ByteArrayDataBlock(null, gridPosition, bytes);
        this.writeBlock(datasetPath, datasetAttributes, dataBlock);
    }
}

