/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.export.ProgressWriter;
import bdv.ij.util.ProgressWriterIJ;
import bigwarp.BigWarp;
import bigwarp.BigWarpData;
import bigwarp.BigWarpInit;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.plugin.PlugIn;
import java.io.File;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.SpimDataException;
import org.janelia.utility.ui.RepeatingReleasedEventsFixer;

public class BigWarpImagePlusPlugIn
implements PlugIn {
    private ImagePlus movingIp;
    private ImagePlus targetIp;

    public static void main(String[] args) {
        new ImageJ();
        IJ.run((String)"Boats (356K)");
        new BigWarpImagePlusPlugIn().run(null);
    }

    public void run(String arg) {
        if (IJ.versionLessThan((String)"1.40")) {
            return;
        }
        int[] ids = WindowManager.getIDList();
        int N = ids == null ? 0 : ids.length;
        String[] titles = new String[N + 1];
        for (int i = 0; i < N; ++i) {
            titles[i] = WindowManager.getImage((int)ids[i]).getTitle();
        }
        titles[N] = "<None>";
        GenericDialogPlus gd = new GenericDialogPlus("Big Warp Setup");
        gd.addMessage("Image Selection:");
        ImagePlus currimg = WindowManager.getCurrentImage();
        String current = titles[N];
        if (currimg != null) {
            current = currimg.getTitle();
        }
        gd.addChoice("moving_image", titles, current);
        if (titles.length > 1) {
            gd.addChoice("target_image", titles, current.equals(titles[0]) ? titles[1] : titles[0]);
        } else {
            gd.addChoice("target_image", titles, titles[0]);
        }
        gd.addMessage("\nN5/Zarr/HDF5/BDV-XML");
        gd.addDirectoryOrFileField("Moving", "");
        gd.addStringField("Moving dataset", "");
        gd.addDirectoryOrFileField("Target", "");
        gd.addStringField("Target dataset", "");
        gd.addMessage("");
        gd.addFileField("Landmarks file", "");
        gd.addCheckbox("Apply transform from landmarks", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int mvgImgIdx = gd.getNextChoiceIndex();
        int tgtImgIdx = gd.getNextChoiceIndex();
        this.movingIp = mvgImgIdx < N ? WindowManager.getImage((int)ids[mvgImgIdx]) : null;
        this.targetIp = tgtImgIdx < N ? WindowManager.getImage((int)ids[tgtImgIdx]) : null;
        String mvgRoot = gd.getNextString();
        String mvgDataset = gd.getNextString();
        String tgtRoot = gd.getNextString();
        String tgtDataset = gd.getNextString();
        String landmarkPath = gd.getNextString();
        boolean applyTransform = gd.getNextBoolean();
        BigWarpData bigwarpdata = BigWarpInit.initData();
        int id = 0;
        if (this.movingIp != null) {
            id += BigWarpInit.add(bigwarpdata, this.movingIp, id, 0, true);
        }
        SpimData movingSpimData = null;
        if (!mvgRoot.isEmpty()) {
            if (BigWarpImagePlusPlugIn.openWithImageJ(mvgRoot)) {
                ImagePlus mvgIpFromFile = IJ.openImage((String)mvgRoot);
                mvgIpFromFile.show();
                BigWarpInit.add(bigwarpdata, mvgIpFromFile, id, 0, true);
            } else {
                movingSpimData = BigWarpInit.addToData(bigwarpdata, true, id, mvgRoot, mvgDataset);
            }
            ++id;
        }
        if (this.targetIp != null) {
            id += BigWarpInit.add(bigwarpdata, this.targetIp, id, 0, false);
        }
        if (!tgtRoot.isEmpty()) {
            if (BigWarpImagePlusPlugIn.openWithImageJ(tgtRoot)) {
                ImagePlus tgtIpFromFile = IJ.openImage((String)tgtRoot);
                tgtIpFromFile.show();
                BigWarpInit.add(bigwarpdata, tgtIpFromFile, id, 0, false);
            } else {
                BigWarpInit.addToData(bigwarpdata, false, id, tgtRoot, tgtDataset);
            }
            ++id;
        }
        bigwarpdata.wrapUp();
        try {
            new RepeatingReleasedEventsFixer().install();
            BigWarp bw = new BigWarp(bigwarpdata, (ProgressWriter)new ProgressWriterIJ());
            if (landmarkPath != null && !landmarkPath.isEmpty()) {
                bw.loadLandmarks(landmarkPath);
                if (applyTransform) {
                    bw.setIsMovingDisplayTransformed(applyTransform);
                }
            }
            if (movingSpimData != null) {
                bw.setMovingSpimData(movingSpimData, new File(mvgRoot));
            }
            bw.getViewerFrameP().getViewerPanel().requestRepaint();
            bw.getViewerFrameQ().getViewerPanel().requestRepaint();
            bw.getLandmarkFrame().repaint();
        }
        catch (SpimDataException e) {
            e.printStackTrace();
            return;
        }
    }

    private static boolean openWithImageJ(String rootPath) {
        String rootPathNorm = rootPath.replaceFirst("/*$", "");
        return !rootPathNorm.endsWith(".n5") && !rootPathNorm.endsWith(".zarr") && !rootPathNorm.endsWith(".h5") && !rootPathNorm.endsWith(".xml") && !rootPathNorm.endsWith(".hdf5");
    }
}

