/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJGradient;
import VolumeJ.VJLight;
import VolumeJ.VJShade;
import VolumeJ.VJShader;

public class VJPhongShader
extends VJShader {
    private float ambient;
    private float diffuse;

    public VJPhongShader(float ambient, VJLight light, boolean doBackface) {
        this.ambient = ambient;
        this.doBackface = doBackface;
        this.light = light;
        this.diffuse = light.getDiffuse();
    }

    @Override
    public VJShade shade(VJGradient g) {
        if (g.getDimensions() == 1) {
            float dot = g.getx() * this.light.getx() + g.gety() * this.light.gety() + g.getz() * this.light.getz();
            if (this.doBackface) {
                dot = Math.abs(dot);
            } else if (dot < 0.0f) {
                dot = 0.0f;
            }
            return new VJShade(this.ambient + this.diffuse * dot);
        }
        float[] dot = new float[3];
        dot[0] = g.getx(0) * this.light.getx() + g.gety(1) * this.light.gety() + g.getz(2) * this.light.getz();
        if (dot[0] < 0.0f && this.doBackface) {
            dot[0] = Math.abs(dot[0]);
        } else if (dot[0] < 0.0f) {
            dot[0] = 0.0f;
        }
        dot[1] = g.getx(0) * this.light.getx() + g.gety(1) * this.light.gety() + g.getz(2) * this.light.getz();
        if (dot[1] < 0.0f && this.doBackface) {
            dot[1] = Math.abs(dot[1]);
        } else if (dot[1] < 0.0f) {
            dot[1] = 0.0f;
        }
        dot[2] = g.getx(0) * this.light.getx() + g.gety(1) * this.light.gety() + g.getz(2) * this.light.getz();
        if (dot[2] < 0.0f && this.doBackface) {
            dot[2] = Math.abs(dot[2]);
        } else if (dot[2] < 0.0f) {
            dot[2] = 0.0f;
        }
        return new VJShade(this.ambient + this.diffuse * dot[0], this.ambient + this.diffuse * dot[1], this.ambient + this.diffuse * dot[2]);
    }

    @Override
    public String toString() {
        return "Phong shader: " + this.ambient + " " + this.diffuse + " " + this.light;
    }
}

