/*
 * Decompiled with CFR 0.152.
 */
package numericalMethods.calculus.minimizing;

import java.io.Serializable;
import numericalMethods.calculus.minimizing.nmLineNDBrent;
import numericalMethods.function.nmDoubleArrayParametrized;
import numericalMethods.function.nmDoubleValued;

public final class nmPowell
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int ITMAX = 200;
    private static final double TOL = 2.0E-4;
    private static boolean debug = false;
    private static int iter;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int v) {
        ITMAX = v;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void setDebug(boolean v) {
        debug = v;
    }

    static final double sqr(double a) {
        return a * a;
    }

    public static int getIter() {
        return iter;
    }

    public static double[][] getStandardBasis(int dim) {
        double[][] basis = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            basis[i][i] = 1.0;
        }
        return basis;
    }

    public static final double search(double[] p, double ftol, nmDoubleValued f) {
        return nmPowell.search(p, nmPowell.getStandardBasis(p.length), ftol, f);
    }

    public static final double search(double[] p, double[][] xi, double ftol, nmDoubleValued f) {
        nmDoubleArrayParametrized F = (nmDoubleArrayParametrized)((Object)f);
        return nmPowell.search(p, xi, ftol, F, f);
    }

    public static final double search(double[] p, double[][] xi, double ftol, nmDoubleArrayParametrized F, nmDoubleValued f) {
        return nmPowell.search(p, xi, ftol, F, f, ITMAX, debug);
    }

    public static final double search(double[] p, double ftol, nmDoubleArrayParametrized F, nmDoubleValued f, int n, boolean debug) {
        return nmPowell.search(p, nmPowell.getStandardBasis(p.length), ftol, F, f, n, debug);
    }

    public static double search(double[] p, double[][] xi, double ftol, nmDoubleArrayParametrized F, nmDoubleValued f, int itMax, boolean debug) {
        double[] aTuple = new double[2];
        int n = p.length;
        double[] pt = new double[n];
        double[] ptt = new double[n];
        double[] xit = new double[n];
        nmLineNDBrent lineNDBrent = new nmLineNDBrent(F, f, p, xit);
        F.setDoubleArrayParameter(p, 0);
        double fret = f.getDoubleValue();
        if (debug) {
            String s = new String(String.valueOf(String.valueOf(new StringBuffer(" f(p) = ").append(fret).append(" , p = "))));
            for (int i = 0; i < n; ++i) {
                s = String.valueOf(s) + String.valueOf(String.valueOf(String.valueOf(p[i])).concat(" "));
            }
            System.out.println(s);
        }
        for (int j = 0; j < n; ++j) {
            pt[j] = p[j];
        }
        iter = 1;
        while (true) {
            double t;
            double fptt;
            double fp = fret;
            int ibig = 0;
            double del = 0.0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    xit[j] = xi[j][i];
                }
                fptt = fret;
                if (!(Math.abs(fptt - (fret = lineNDBrent.search())) > del)) continue;
                del = Math.abs(fptt - fret);
                ibig = i;
            }
            if (debug) {
                String s = new String(String.valueOf(String.valueOf(new StringBuffer("iter = ").append(iter).append(", fret = ").append(fret).append(", fp = ").append(fp).append(", p = "))));
                for (int i = 0; i < n; ++i) {
                    s = String.valueOf(s) + String.valueOf(String.valueOf(String.valueOf(p[i])).concat(" "));
                }
                System.out.println(s);
            }
            if (2.0 * Math.abs(fp - fret) <= ftol * (Math.abs(fp) + Math.abs(fret))) {
                return fret;
            }
            if (debug && iter >= itMax) {
                System.out.println("Too many iterations in routine POWELL");
                return fret;
            }
            for (int j = 0; j < n; ++j) {
                ptt[j] = 2.0 * p[j] - pt[j];
                xit[j] = p[j] - pt[j];
                pt[j] = p[j];
            }
            F.setDoubleArrayParameter(ptt, 0);
            fptt = f.getDoubleValue();
            if (fptt < fp && (t = 2.0 * (fp - 2.0 * fret + fptt) * nmPowell.sqr(fp - fret - del) - del * nmPowell.sqr(fp - fptt)) < 0.0) {
                fret = lineNDBrent.search();
                for (int j = 0; j < n; ++j) {
                    xi[j][ibig] = xit[j];
                }
            }
            ++iter;
        }
    }
}

