/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.expressions.Temp;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tree.TreeNode;

public class TreeBuilder {
    private List<Statement> trees = Lists.newArrayList();
    private Map<LValue, Assignment> definition = Maps.newHashMap();
    private Map<LValue, Integer> uses = Maps.newHashMap();
    private Set<LValue> usedOnce = Sets.newHashSet();
    private Set<Assignment> embeded = Sets.newHashSet();

    public static List<Statement> build(BasicBlock block) {
        return new TreeBuilder().doBuild(block);
    }

    private List<Statement> doBuild(BasicBlock block) {
        for (Statement statement : block.getStatements()) {
            this.checkUses(statement.getRHS());
            if (statement instanceof Assignment) {
                Assignment assn = (Assignment)statement;
                this.definition.put(assn.getLHS(), assn);
            }
            this.trees.add(statement);
        }
        for (Map.Entry entry : this.uses.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            this.usedOnce.add((LValue)entry.getKey());
        }
        System.out.println("used once = " + this.usedOnce);
        for (Statement statement : block.getStatements()) {
            this.embed(statement);
        }
        this.trees.removeAll(this.embeded);
        return this.trees;
    }

    private void embed(TreeNode treeNode) {
        List<Expression> children = treeNode.getChildren();
        for (int i = 0; i != children.size(); ++i) {
            Expression child = children.get(i);
            if (this.usedOnce.contains(child)) {
                Assignment assignment = this.definition.get(child);
                if (assignment == null) continue;
                treeNode.setChild(i, assignment.getRHS());
                this.embeded.add(assignment);
                continue;
            }
            this.embed(child);
        }
    }

    private void checkUses(Expression expr) {
        if (expr instanceof Temp) {
            this.incrementUseCount((LValue)expr);
        }
        for (Expression child : expr.getChildren()) {
            this.checkUses(child);
        }
    }

    private void incrementUseCount(LValue lvalue) {
        Integer count = this.uses.get(lvalue);
        if (count == null) {
            this.uses.put(lvalue, 1);
        } else {
            this.uses.put(lvalue, count + 1);
        }
    }

    private int getUseCount(LValue lvalue) {
        Integer count = this.uses.get(lvalue);
        return count == null ? 0 : count;
    }
}

