/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.renjin.primitives.subset.Selection;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;

public class CompleteSelection
extends Selection {
    private SEXP source;
    private AtomicVector sourceDim;

    public CompleteSelection(SEXP source) {
        super(source);
        this.source = source;
        this.sourceDim = (AtomicVector)source.getAttributes().getDim();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new UnmodifiableIterator<Integer>(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < CompleteSelection.this.source.length();
            }

            public Integer next() {
                return this.i++;
            }
        };
    }

    @Override
    public int getSourceDimensions() {
        if (this.sourceDim.length() == 0) {
            return 1;
        }
        return this.sourceDim.length();
    }

    @Override
    public int getElementCount() {
        return this.source.length();
    }

    @Override
    public int[] getSubscriptDimensions() {
        if (this.sourceDim.length() == 0) {
            return new int[]{this.source.length()};
        }
        return ((IntVector)this.sourceDim).toIntArray();
    }

    private int getDimensionLength(int d) {
        if (this.sourceDim.length() == 0 && d == 0) {
            return this.source.length();
        }
        return this.sourceDim.getElementAsInt(d);
    }

    @Override
    protected AtomicVector getNames(int dimensionIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Integer> getSelectionAlongDimension(int dimensionIndex) {
        final int length2 = this.getDimensionLength(dimensionIndex);
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new UnmodifiableIterator<Integer>(){
                    private int i = 0;

                    public boolean hasNext() {
                        return this.i < length2;
                    }

                    public Integer next() {
                        return this.i++;
                    }
                };
            }
        };
    }
}

