/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.LogicalSubscript;
import org.renjin.primitives.subset.MissingSubscript;
import org.renjin.primitives.subset.NamedSubscript;
import org.renjin.primitives.subset.NegativeSubscript;
import org.renjin.primitives.subset.NullSubscript;
import org.renjin.primitives.subset.PositionalSubscript;
import org.renjin.primitives.subset.Subscript;
import org.renjin.primitives.vector.RowNamesVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public abstract class Selection
implements Iterable<Integer> {
    private final SEXP source;

    public Selection(SEXP source) {
        this.source = source;
    }

    public abstract int getSourceDimensions();

    public abstract int getElementCount();

    public abstract Iterable<Integer> getSelectionAlongDimension(int var1);

    public boolean isEmpty() {
        return this.getElementCount() == 0;
    }

    public abstract int[] getSubscriptDimensions();

    protected abstract AtomicVector getNames(int var1);

    protected final Subscript parseSubscript(SEXP argument, int dimensionIndex, int dimensionLength) {
        if (argument == Symbol.MISSING_ARG) {
            return new MissingSubscript(dimensionLength);
        }
        if (argument instanceof LogicalVector) {
            return new LogicalSubscript(dimensionLength, (LogicalVector)argument);
        }
        if (argument instanceof StringVector) {
            return new NamedSubscript(dimensionLength, this.getNames(dimensionIndex), (StringVector)argument);
        }
        if (argument instanceof DoubleVector || argument instanceof IntVector) {
            AtomicVector vector2 = (AtomicVector)argument;
            if (PositionalSubscript.arePositions(vector2)) {
                return new PositionalSubscript(vector2);
            }
            return new NegativeSubscript(dimensionLength, vector2);
        }
        if (argument == Null.INSTANCE) {
            return NullSubscript.INSTANCE;
        }
        throw new EvalException("invalid subscript type '%s'", argument.getTypeName());
    }

    protected static int[] dimAsIntArray(SEXP source) {
        SEXP dim2 = source.getAttribute(Symbols.DIM);
        if (!(dim2 instanceof IntVector)) {
            return new int[]{source.length()};
        }
        return ((IntVector)dim2).toIntArray();
    }

    public Vector getDimensionNames(int dimIndex) {
        Vector sourceNames;
        Vector dimNames = (Vector)this.source.getAttribute(Symbols.DIMNAMES);
        if (dimNames != Null.INSTANCE && (sourceNames = RowNamesVector.purify(dimNames.getElementAsSEXP(dimIndex))) != Null.INSTANCE) {
            return this.selectDimensionNames(dimIndex, sourceNames);
        }
        return Null.INSTANCE;
    }

    protected Vector selectDimensionNames(int dimIndex, Vector sourceNames) {
        StringVector.Builder names2 = new StringVector.Builder();
        for (Integer index : this.getSelectionAlongDimension(dimIndex)) {
            if (index >= sourceNames.length()) {
                throw new EvalException("subscript out of bounds: ", new Object[0]);
            }
            names2.add(sourceNames.getElementAsString(index));
        }
        return names2.build();
    }
}

