/*
 * Decompiled with CFR 0.152.
 */
package volumeCalculator;

import ij.IJ;
import ij.gui.ColorChooser;
import ij3d.Image3DUniverse;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import volumeCalculator.AnalyzedGraph;
import volumeCalculator.Volumes;

public class VolumesPanel
extends Panel {
    static final Color FIRST_VOLUME_COLOR = Color.RED;
    static final String MSG_COLOR_USED = "This color is already being used. Please try another one.";
    static final String TITLE_COLOR_CHOOSER = "Volume Color Chooser";
    static final String VOLUME_IN_CUBIC = "Volume in cubic ";
    static final String VOLUME_FORMAT = " %8.3f ";
    private final GridBagConstraints constraints;
    private ColorChooser colorChooser;
    private Volumes volumes;
    private CheckboxGroup checkboxGroup;
    private List<Label> volumeLabels;
    private AnalyzedGraph analyzedGraph;
    private Image3DUniverse universe;
    private Button addColorVolumeButton;
    private Checkbox boundingBoxCheckbox;
    private Checkbox keyNavigationOnlyCheckbox;
    private Panel panel1;
    private Panel panel2;
    private ScrollPane scrollPane1;
    private Label statusLabel;
    private Label volumeUnitsLabel;
    private Panel volumesPanel;

    public VolumesPanel(Volumes volumes, AnalyzedGraph analyzedGraph, Image3DUniverse universe) {
        this.volumes = volumes;
        this.analyzedGraph = analyzedGraph;
        this.universe = universe;
        this.initComponents();
        this.volumeUnitsLabel.setText(VOLUME_IN_CUBIC + volumes.getCalibrationUnits());
        this.volumeLabels = new ArrayList<Label>();
        this.checkboxGroup = new CheckboxGroup();
        this.constraints = new GridBagConstraints();
        Label Fill = new Label("");
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 3;
        this.volumesPanel.add((Component)Fill, this.constraints);
        volumes.addVolumeColor(FIRST_VOLUME_COLOR);
        this.addVolumeDisplayLine(FIRST_VOLUME_COLOR, true);
        this.scrollPane1.validate();
        this.validate();
    }

    private void initComponents() {
        this.volumeUnitsLabel = new Label();
        this.scrollPane1 = new ScrollPane();
        this.volumesPanel = new Panel();
        this.panel1 = new Panel();
        this.statusLabel = new Label();
        this.boundingBoxCheckbox = new Checkbox();
        this.keyNavigationOnlyCheckbox = new Checkbox();
        this.panel2 = new Panel();
        this.addColorVolumeButton = new Button();
        this.setLayout(new BorderLayout());
        this.volumeUnitsLabel.setAlignment(1);
        this.volumeUnitsLabel.setText("Volume in ");
        this.add((Component)this.volumeUnitsLabel, "North");
        this.volumesPanel.setLayout(new GridBagLayout());
        this.scrollPane1.add(this.volumesPanel);
        this.add((Component)this.scrollPane1, "Center");
        this.statusLabel.setFont(new Font("Dialog", 1, 12));
        this.statusLabel.setText("                                  ");
        this.panel1.add(this.statusLabel);
        this.boundingBoxCheckbox.setLabel("Bounding Box ");
        this.boundingBoxCheckbox.setName("boundingBoxCheckBox");
        this.boundingBoxCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                VolumesPanel.this.boundingBoxCheckboxItemStateChanged(evt);
            }
        });
        this.panel1.add(this.boundingBoxCheckbox);
        this.keyNavigationOnlyCheckbox.setLabel("Key Nav. Only");
        this.keyNavigationOnlyCheckbox.setState(true);
        this.panel1.add(this.keyNavigationOnlyCheckbox);
        this.panel1.add(this.panel2);
        this.addColorVolumeButton.setCursor(new Cursor(0));
        this.addColorVolumeButton.setLabel("New Volume Color");
        this.addColorVolumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolumesPanel.this.addColorVolumeButtonActionPerformed(evt);
            }
        });
        this.panel1.add(this.addColorVolumeButton);
        this.addColorVolumeButton.getAccessibleContext().setAccessibleName("");
        this.add((Component)this.panel1, "South");
    }

    private void addColorVolumeButtonActionPerformed(ActionEvent evt) {
        this.colorChooser = new ColorChooser(TITLE_COLOR_CHOOSER, Color.white, false);
        Color chosenColor = this.colorChooser.getColor();
        if (chosenColor != null) {
            if (!this.volumes.addVolumeColor(chosenColor)) {
                IJ.showMessage((String)MSG_COLOR_USED);
            } else {
                this.addVolumeDisplayLine(chosenColor, true);
            }
        }
    }

    private void boundingBoxCheckboxItemStateChanged(ItemEvent evt) {
        if (this.boundingBoxCheckbox.getState()) {
            this.universe.setShowBoundingBoxUponSelection(true);
        } else {
            this.universe.setShowBoundingBoxUponSelection(false);
        }
    }

    private void addVolumeDisplayLine(Color chosenColor, boolean isOn) {
        this.constraints.insets = new Insets(1, 1, 6, 1);
        this.constraints.gridx = 0;
        ++this.constraints.gridy;
        this.constraints.gridwidth = 1;
        Checkbox checkbox = new Checkbox("", this.checkboxGroup, isOn);
        checkbox.setName("" + this.volumes.getCurrentColorIndex());
        checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                Checkbox checkbox = (Checkbox)ie.getSource();
                int parseInt = Integer.parseInt(checkbox.getName());
                VolumesPanel.this.volumes.setCurrentColorIndex(parseInt);
            }
        });
        Dimension size = this.volumesPanel.getSize();
        this.volumesPanel.add((Component)checkbox, this.constraints);
        Label label00 = new Label("       ");
        label00.setBackground(chosenColor);
        ++this.constraints.gridx;
        this.volumesPanel.add((Component)label00, this.constraints);
        Label volumeLabel = new Label("                  ");
        ++this.constraints.gridx;
        this.volumesPanel.add((Component)volumeLabel, this.constraints);
        Button clearButton = new Button("C");
        clearButton.setActionCommand("" + this.volumes.getCurrentColorIndex());
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int colorIndex = Integer.parseInt(ae.getActionCommand());
                VolumesPanel.this.analyzedGraph.resetColor(VolumesPanel.this.volumes.getColorAt(colorIndex));
                VolumesPanel.this.volumes.clearVoxelCount(colorIndex);
                VolumesPanel.this.updateVoxelCount(colorIndex);
            }
        });
        ++this.constraints.gridx;
        this.volumesPanel.add((Component)clearButton, this.constraints);
        this.volumesPanel.setSize(size);
        this.validate();
        this.scrollPane1.setScrollPosition(600, 600);
        this.volumeLabels.add(volumeLabel);
    }

    void updateVoxelCount(int colorIndex) {
        if (colorIndex == 99) {
            return;
        }
        String text = String.format(VOLUME_FORMAT, this.volumes.getVolumeAt(colorIndex));
        Label label = this.volumeLabels.get(colorIndex);
        label.setText(text);
    }

    void showStatus(String message) {
        this.statusLabel.setText(message);
    }

    boolean getKeyNavigationCheckBoxState() {
        return this.keyNavigationOnlyCheckbox.getState();
    }
}

