/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSImageXmlDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSMetadataExtractor;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSXmlDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.MetadataStoreInitializer;
import loci.formats.in.LeicaMicrosystemsMetadata.MetadataTempBuffer;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import org.slf4j.Logger;

public abstract class LMSFileReader
extends FormatReader {
    public static final String OLD_PHYSICAL_SIZE_KEY = "leicalif.old_physical_size";
    public static final boolean OLD_PHYSICAL_SIZE_DEFAULT = false;
    public static Logger log;
    public MetadataTempBuffer metaTemp;
    public LMSXmlDocument associatedXmlDoc;

    protected LMSFileReader(String format, String suffix) {
        super(format, suffix);
        log = LOGGER;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.metaTemp = null;
        }
    }

    public abstract ImageFormat getImageFormat();

    public List<CoreMetadata> getCore() {
        return this.core;
    }

    public void setCore(ArrayList<CoreMetadata> core) {
        this.core = core;
    }

    public boolean useOldPhysicalSizeCalculation() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(OLD_PHYSICAL_SIZE_KEY, Boolean.valueOf(false));
        }
        return false;
    }

    public void addSeriesMeta(String key, Object value) {
        super.addMeta(key, value, this.getCurrentCore().seriesMetadata);
    }

    public void addSeriesMetaList(String key, Object value) {
        super.addSeriesMetaList(key, value);
    }

    public MetadataStore makeFilterMetadata() {
        return super.makeFilterMetadata();
    }

    public void translateMetadata(List<LMSImageXmlDocument> docs) throws FormatException, IOException {
        int len = docs.size();
        this.metaTemp = new MetadataTempBuffer(len);
        LMSMetadataExtractor extractor = new LMSMetadataExtractor(this);
        extractor.translateMetadata(docs);
        MetadataStoreInitializer initializer = new MetadataStoreInitializer(this);
        initializer.initMetadataStore();
    }

    public void translateMetadata(LMSImageXmlDocument doc) throws FormatException, IOException {
        ArrayList<LMSImageXmlDocument> docs = new ArrayList<LMSImageXmlDocument>();
        docs.add(doc);
        this.translateMetadata(docs);
    }

    public static boolean fileExists(String path) {
        if (path != null && !path.trim().isEmpty()) {
            try {
                File f = new File(path);
                if (f.exists()) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static enum ImageFormat {
        LOF,
        TIF,
        BMP,
        JPEG,
        PNG,
        UNKNOWN;

    }
}

