/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyramidTiffReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PyramidTiffReader.class);

    public PyramidTiffReader() {
        super("Pyramid TIFF", new String[]{"tif", "tiff"});
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.equalStrips = true;
        this.noSubresolutions = true;
        this.canSeparateSeries = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setAssumeEqualStrips(this.equalStrips);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        if (software == null) {
            return false;
        }
        return software.indexOf("Faas") >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int index = this.getCoreIndex();
        this.tiffParser.setAssumeEqualStrips(this.equalStrips);
        this.tiffParser.getSamples((IFD)this.ifds.get(index), buf, x, y, (long)w, (long)h);
        return buf;
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            return (int)((IFD)this.ifds.get(this.getCoreIndex())).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", (Throwable)e);
            return super.getOptimalTileWidth();
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            return (int)((IFD)this.ifds.get(this.getCoreIndex())).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", (Throwable)e);
            return super.getOptimalTileHeight();
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int seriesCount = this.ifds.size();
        this.core.clear();
        this.core.add();
        for (int s = 0; s < seriesCount; ++s) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(0, ms);
            if (s == 0) {
                ms.resolutionCount = seriesCount;
            }
            IFD ifd = (IFD)this.ifds.get(s);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            ms.rgb = samples > 1 || p == PhotoInterp.RGB;
            long numTileRows = ifd.getTilesPerColumn() - 1L;
            long numTileCols = ifd.getTilesPerRow() - 1L;
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = 1;
            ms.sizeT = 1;
            ms.sizeC = ms.rgb ? samples : 1;
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            ms.imageCount = 1;
            ms.pixelType = ifd.getPixelType();
            ms.metadataComplete = true;
            ms.interleaved = false;
            ms.falseColor = false;
            ms.dimensionOrder = "XYCZT";
            ms.thumbnail = s > 0;
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
        }
    }
}

