/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.api;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLContext;
import net.haesleinhuepf.clij.clearcl.enums.HostAccessType;
import net.haesleinhuepf.clij.clearcl.enums.KernelAccessType;
import net.haesleinhuepf.clij.clearcl.enums.MemAllocMode;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;

class ClearCLBufferPool
implements AutoCloseable {
    private final ClearCLContext context;
    private final Map<Specification, Queue<ClearCLBuffer>> unused = new ConcurrentHashMap<Specification, Queue<ClearCLBuffer>>();

    ClearCLBufferPool(ClearCLContext context) {
        this.context = context;
    }

    public ClearCLBuffer create(long[] dimensions, long numberOfChannels, NativeTypeEnum type) {
        ClearCLBuffer buffer;
        Specification key = new Specification(dimensions, numberOfChannels, type);
        Queue<ClearCLBuffer> list = this.unused.get(key);
        if (list != null && (buffer = list.poll()) != null) {
            return buffer;
        }
        return this.context.createBuffer(MemAllocMode.Best, HostAccessType.ReadWrite, KernelAccessType.ReadWrite, numberOfChannels, type, dimensions);
    }

    public void release(ClearCLBuffer buffer) {
        Specification key = new Specification(buffer.getDimensions(), buffer.getNumberOfChannels(), buffer.getNativeType());
        Queue list = this.unused.computeIfAbsent(key, ignore -> new ConcurrentLinkedQueue());
        list.add(buffer);
    }

    @Override
    public void close() {
        this.clear();
    }

    private void closeAll(Queue<ClearCLBuffer> list) {
        ClearCLBuffer buffer;
        while ((buffer = list.poll()) != null) {
            buffer.close();
        }
    }

    public void clear() {
        for (Queue<ClearCLBuffer> list : this.unused.values()) {
            this.closeAll(list);
        }
    }

    private static class Specification {
        private final long[] dimensions;
        private final long numberOfChannels;
        private final NativeTypeEnum type;
        private final int hash;

        private Specification(long[] dimensions, long numberOfChannels, NativeTypeEnum type) {
            this.dimensions = (long[])dimensions.clone();
            this.numberOfChannels = numberOfChannels;
            this.type = type;
            this.hash = Objects.hash(Arrays.hashCode(dimensions), numberOfChannels, type);
        }

        public boolean equals(Object obj) {
            return obj instanceof Specification && Arrays.equals(this.dimensions, ((Specification)obj).dimensions) && this.numberOfChannels == ((Specification)obj).numberOfChannels && this.type.equals((Object)((Specification)obj).type);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

