/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.compute_cache;

import java.util.Objects;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.util.Intervals;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuImage;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuPixelWiseOperation;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuViews;
import sc.fiji.labkit.pixel_classification.gpu.compute_cache.GpuComputeCache;

public class GpuSecondDerivativeContent
implements GpuComputeCache.Content {
    private final GpuComputeCache cache;
    private final GpuComputeCache.Content input;
    private final int d;

    public GpuSecondDerivativeContent(GpuComputeCache cache, GpuComputeCache.Content input, int d) {
        this.cache = cache;
        this.input = input;
        this.d = d;
    }

    public int hashCode() {
        return Objects.hash(this.input, this.d);
    }

    public boolean equals(Object obj) {
        return obj instanceof GpuSecondDerivativeContent && this.input.equals(((GpuSecondDerivativeContent)obj).input) && this.d == ((GpuSecondDerivativeContent)obj).d;
    }

    @Override
    public void request(Interval interval) {
        this.cache.request(this.input, (Interval)this.requiredInput(interval));
    }

    private FinalInterval requiredInput(Interval interval) {
        return GpuSecondDerivativeContent.expand(interval, 1, this.d);
    }

    private static FinalInterval expand(Interval interval, int border, int d) {
        long[] b = new long[interval.numDimensions()];
        b[d] = border;
        return Intervals.expand((Interval)interval, (long[])b);
    }

    @Override
    public GpuImage load(Interval interval) {
        GpuApi gpu = this.cache.gpuApi();
        double[] pixelSize = this.cache.pixelSize();
        GpuView source = this.cache.get(this.input, (Interval)this.requiredInput(interval));
        FinalInterval centerInterval = GpuSecondDerivativeContent.expand((Interval)new FinalInterval(source.dimensions()), -1, this.d);
        GpuView center = GpuViews.crop(source, (Interval)centerInterval);
        GpuView front = GpuViews.crop(source, (Interval)Intervals.translate((Interval)centerInterval, (long)1L, (int)this.d));
        GpuView back = GpuViews.crop(source, (Interval)Intervals.translate((Interval)centerInterval, (long)-1L, (int)this.d));
        GpuImage result = gpu.create(Intervals.dimensionsAsLongArray((Dimensions)interval), NativeTypeEnum.Float);
        GpuPixelWiseOperation.gpu(gpu).addInput("f", front).addInput("b", back).addInput("c", center).addOutput("r", result).addInput("factor", (float)(1.0 / Math.pow(pixelSize[this.d], 2.0))).forEachPixel("r = (f + b - 2 * c) * factor");
        return result;
    }
}

