/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.scijava.Context;
import sc.fiji.labkit.pixel_classification.gui.AccordionPanel;
import sc.fiji.labkit.pixel_classification.gui.AvailableFeatures;
import sc.fiji.labkit.pixel_classification.gui.FeatureInfo;
import sc.fiji.labkit.pixel_classification.gui.FiltersListSection;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.dog2.DifferenceOfGaussiansFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.gauss.GaussianBlurFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.gradient.GaussianGradientMagnitudeFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.hessian.HessianEigenvaluesFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.identity.IdentityFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.laplacian.LaplacianOfGaussianFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats.MaxFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats.MeanFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats.MinFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats.VarianceFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.structure.StructureTensorEigenvaluesFeature;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSetting;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSettings;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

public class FiltersPanel
extends JPanel {
    private static final List<Class<?>> BASIC_FILTERS = Arrays.asList(IdentityFeature.class, GaussianBlurFeature.class, DifferenceOfGaussiansFeature.class, GaussianGradientMagnitudeFeature.class, LaplacianOfGaussianFeature.class, HessianEigenvaluesFeature.class, StructureTensorEigenvaluesFeature.class, MinFeature.class, MaxFeature.class, MeanFeature.class, VarianceFeature.class);
    private List<FeatureInfo> deprecatedFilters;
    private List<FeatureInfo> basicFilters;
    private List<FeatureInfo> advancedFilters;
    private List<FiltersListSection> sections;
    private Context context;

    public FiltersPanel(Context context, FeatureSettings fs) {
        this.context = context;
        this.setLayout(new BoxLayout(this, 1));
        this.initUI(fs);
    }

    private void initUI(FeatureSettings fs) {
        this.populateFeatureSettingArrays();
        this.sections = new ArrayList<FiltersListSection>();
        AccordionPanel accordion = new AccordionPanel();
        accordion.addSection(this.newSection(fs, "Basic Filters", this.basicFilters, true));
        accordion.addSection(this.newSection(fs, "Customizable Filters", this.advancedFilters, false));
        accordion.addSection(this.newSection(fs, "Deprecated Filters", this.deprecatedFilters, false));
        this.add(accordion);
    }

    private FiltersListSection newSection(FeatureSettings fs, String title, List<FeatureInfo> basicFilters, boolean isExpanded) {
        FiltersListSection basic = new FiltersListSection(title, this.context, fs, basicFilters, isExpanded);
        this.sections.add(basic);
        return basic;
    }

    private void populateFeatureSettingArrays() {
        List<FeatureInfo> featureInfos = AvailableFeatures.getFeatures(this.context);
        this.basicFilters = new ArrayList<FeatureInfo>();
        this.advancedFilters = new ArrayList<FeatureInfo>();
        this.deprecatedFilters = new ArrayList<FeatureInfo>();
        featureInfos.sort(Comparator.comparing(FeatureInfo::getName));
        for (FeatureInfo featureInfo : featureInfos) {
            if (featureInfo.isDeprecated()) {
                this.deprecatedFilters.add(featureInfo);
                continue;
            }
            if (this.isBasic(featureInfo.pluginClass())) {
                this.basicFilters.add(featureInfo);
                continue;
            }
            this.advancedFilters.add(featureInfo);
        }
        this.basicFilters.sort(Comparator.comparing(f -> BASIC_FILTERS.indexOf(f.pluginClass())));
    }

    private boolean isBasic(Class<? extends FeatureOp> clazz) {
        return BASIC_FILTERS.contains(clazz);
    }

    public List<FeatureSetting> getSelectedFeatureSettings() {
        ArrayList<FeatureSetting> selected = new ArrayList<FeatureSetting>();
        for (FiltersListSection section : this.sections) {
            selected.addAll(section.getSelectedFeatureSettings());
        }
        return selected;
    }

    public void setGlobalSetting(GlobalSettings globalSettings) {
        this.sections.forEach(section -> section.setGlobalSettings(globalSettings));
    }
}

