/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.utils;

import sc.fiji.labkit.pixel_classification.utils.FastSqrt;

public class CubicEquation {
    private static final double PRECISION = CubicEquation.timesPowerOf2(1.0, -50L);

    public static void solve(double a0, double a1, double a2, double a3, double[] x) {
        if (a3 == 0.0) {
            throw new IllegalArgumentException();
        }
        double h = 1.0 / a3;
        CubicEquation.solveNormalized(a0 * h, a1 * h, a2 * h, x);
    }

    public static void solveNormalized(double b0, double b1, double b2, double[] x) {
        double s = 0.3333333333333333 * b2;
        double q = (2.0 * s * s - b1) * s + b0;
        double p = b1 - b2 * s;
        CubicEquation.solveDepressed(q, p, x);
        x[0] = x[0] - s;
        x[1] = x[1] - s;
        x[2] = x[2] - s;
    }

    public static void solveDepressed(double b0, double b1, double[] x) {
        long e0 = CubicEquation.log2(b0) / 3L;
        long e1 = CubicEquation.log2(b1) / 2L;
        long e = -1L - CubicEquation.max(CubicEquation.max(e0, e1), -20L);
        double scaleFactor = CubicEquation.timesPowerOf2(1.0, -e);
        b1 = CubicEquation.timesPowerOf2(b1, 2L * e);
        b0 = CubicEquation.timesPowerOf2(b0, 3L * e);
        CubicEquation.solveScaled(b0, b1, x);
        x[0] = x[0] * scaleFactor;
        x[1] = x[1] * scaleFactor;
        x[2] = x[2] * scaleFactor;
    }

    static void solveScaled(double b0, double b1, double[] x) {
        double h;
        x[2] = h = CubicEquation.findRoot(b0, b1);
        CubicEquation.solve_quadratic(h * h + b1, h, x);
        if (x[1] > x[2]) {
            CubicEquation.swap(x, 1, 2);
        }
        if (x[0] > x[1]) {
            CubicEquation.swap(x, 0, 1);
        }
    }

    private static double findRoot(double b0, double b1) {
        double dx;
        if (b0 == 0.0) {
            return 0.0;
        }
        double w = CubicEquation.max(CubicEquation.abs(b0), CubicEquation.abs(b1)) + 1.0;
        double x = b0 > 0.0 ? -w : w;
        do {
            dx = CubicEquation.halleysMethod(b0, b1, x);
            x -= dx;
        } while (CubicEquation.abs(dx) > CubicEquation.abs(PRECISION * w));
        return x;
    }

    private static double halleysMethod(double b0, double b1, double x) {
        double x_2 = x * x;
        double y = (x_2 + b1) * x + b0;
        double dy = 3.0 * x_2 + b1;
        double dx = y * dy / (dy * dy - 3.0 * y * x);
        return dx;
    }

    private static void solve_quadratic(double c0, double c1, double[] x) {
        double p = 0.5 * c1;
        double dis = CubicEquation.square(p) - c0;
        dis = dis > 0.0 ? CubicEquation.sqrt(dis) : 0.0;
        x[0] = -p - dis;
        x[1] = -p + dis;
    }

    static long log2(double value) {
        long bits = Double.doubleToRawLongBits(value);
        return (bits >> 52 & 0x7FFL) - 1023L;
    }

    static double timesPowerOf2(double value, long exponent) {
        return value * Double.longBitsToDouble(exponent + 1023L << 52);
    }

    private static double max(double a, double b) {
        return a > b ? a : b;
    }

    private static long max(long a, long b) {
        return a > b ? a : b;
    }

    private static double abs(double value) {
        return Math.abs(value);
    }

    private static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static double square(double value) {
        return value * value;
    }

    private static double sqrt(double value) {
        return FastSqrt.sqrt(value);
    }
}

