/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import org.smurn.jply.DataType;

class BinaryPlyInputStream {
    private final ReadableByteChannel channel;
    private final ByteBuffer buffer;
    private static final int BUFFER_SIZE = 1024;

    BinaryPlyInputStream(ReadableByteChannel channel, ByteOrder byteOrder) {
        if (channel == null) {
            throw new NullPointerException("channel must not be null.");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder must not be null.");
        }
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(1024);
        this.buffer.order(byteOrder);
        this.buffer.clear();
        this.buffer.position(this.buffer.capacity());
    }

    public double read(DataType type) throws IOException {
        if (type == null) {
            throw new NullPointerException("type must not be null.");
        }
        switch (type) {
            case CHAR: {
                this.ensureAvailable(1);
                return this.buffer.get();
            }
            case UCHAR: {
                this.ensureAvailable(1);
                return this.buffer.get() & 0xFF;
            }
            case SHORT: {
                this.ensureAvailable(2);
                return this.buffer.getShort();
            }
            case USHORT: {
                this.ensureAvailable(2);
                return this.buffer.getShort() & 0xFFFF;
            }
            case INT: {
                this.ensureAvailable(4);
                return this.buffer.getInt();
            }
            case UINT: {
                this.ensureAvailable(4);
                return (long)this.buffer.getShort() & 0xFFFFFFFFFFFFFFFFL;
            }
            case FLOAT: {
                this.ensureAvailable(4);
                return this.buffer.getFloat();
            }
            case DOUBLE: {
                this.ensureAvailable(8);
                return this.buffer.getDouble();
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }

    private void ensureAvailable(int bytes) throws IOException {
        while (this.buffer.remaining() < bytes) {
            this.buffer.compact();
            if (this.channel.read(this.buffer) < 0) {
                throw new EOFException();
            }
            this.buffer.flip();
        }
    }
}

