/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.sparse;

import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.sparse.Ntree;
import net.imglib2.img.sparse.NtreeAccess;

public final class DoubleNtree
implements DoubleAccess,
NtreeAccess<Double, DoubleNtree> {
    private final long[] position;
    private final Ntree<Double> data;

    public DoubleNtree(long[] dimensions, long[] position, double value) {
        this.data = new Ntree<Double>(dimensions, value);
        this.position = position;
    }

    private DoubleNtree(Ntree<Double> data, long[] pos) {
        this.data = data;
        this.position = pos;
    }

    @Override
    public double getValue(int index) {
        return this.data.getNode(this.position).getValue();
    }

    @Override
    public void setValue(int index, double value) {
        this.data.createNodeWithValue(this.position, value);
    }

    @Override
    public Ntree<Double> getCurrentStorageNtree() {
        return this.data;
    }

    @Override
    public DoubleNtree createInstance(long[] pos) {
        return new DoubleNtree(this.data, pos);
    }
}

