/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.list;

import java.util.List;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.list.AbstractSerializableListDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyList<E>
extends AbstractSerializableListDecorator<E> {
    private static final long serialVersionUID = -1708388017160694542L;
    protected final Factory<? extends E> factory;

    public static <E> List<E> decorate(List<E> list, Factory<? extends E> factory) {
        return new LazyList<E>(list, factory);
    }

    protected LazyList(List<E> list, Factory<? extends E> factory) {
        super(list);
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = factory;
    }

    @Override
    public E get(int index) {
        int size = this.getList().size();
        if (index < size) {
            Object object = this.getList().get(index);
            if (object == null) {
                object = this.factory.create();
                this.getList().set(index, object);
                return object;
            }
            return object;
        }
        for (int i = size; i < index; ++i) {
            this.getList().add(null);
        }
        E object = this.factory.create();
        this.getList().add(object);
        return object;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List sub = this.getList().subList(fromIndex, toIndex);
        return new LazyList<E>(sub, this.factory);
    }
}

