/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Pattern;
import pal.math.ConjugateDirectionSearch;
import pal.math.MultivariateFunction;
import util.BatchOpener;
import util.Quantile_Based_Normalization;
import vib.Bins;
import vib.ShellsCanvas;
import vib.app.FileGroup;

public class Fit_Sphere
implements PlugIn {
    public void run(String ignored) {
        String averagedNC82Path = "/Users/mark/central-complex-complete-vib-protocol/output_1/71yAAeastmost.tif";
        String normalizedRootDirectory = "/Users/mark/central-complex-complete-vib-protocol/normalized/";
        int[][][] pointsInShells = new int[][][]{new int[][]{{226, 450, 50}, {232, 526, 50}, {250, 364, 50}, {248, 564, 50}, {254, 360, 47}, {226, 420, 47}, {228, 506, 47}, {244, 544, 47}, {246, 376, 44}, {222, 456, 44}, {240, 530, 44}}, new int[][]{{270, 456, 50}, {298, 360, 50}, {290, 540, 50}, {292, 382, 47}, {268, 456, 47}, {284, 522, 47}, {280, 524, 44}, {266, 456, 44}, {290, 386, 44}}};
        int[] pointInferiorLowZ = new int[]{294, 466, 43};
        int[] pointInferiorHighZ = new int[]{294, 466, 49};
        int[] pointSuperiorLowZ = new int[]{234, 484, 42};
        int[] pointSuperiorHighZ = new int[]{234, 484, 50};
        ImagePlus[] channels = BatchOpener.open((String)averagedNC82Path);
        if (channels == null) {
            IJ.error((String)("Couldn't open: " + averagedNC82Path));
        }
        ImagePlus imp = channels[0];
        Calibration c = channels[0].getCalibration();
        double x_spacing = c.pixelWidth;
        double y_spacing = c.pixelHeight;
        double z_spacing = c.pixelDepth;
        int width = imp.getWidth();
        int height = imp.getHeight();
        int depth = imp.getStackSize();
        double[] pointMaxZDefiningAngle = new double[3];
        double[] pointMinZDefiningAngle = new double[3];
        pointMaxZDefiningAngle[0] = (double)pointInferiorHighZ[0] * x_spacing;
        pointMaxZDefiningAngle[1] = (double)pointInferiorHighZ[1] * y_spacing;
        pointMaxZDefiningAngle[2] = (double)pointInferiorHighZ[2] * z_spacing;
        pointMinZDefiningAngle[0] = (double)pointInferiorLowZ[0] * x_spacing;
        pointMinZDefiningAngle[1] = (double)pointInferiorLowZ[1] * y_spacing;
        pointMinZDefiningAngle[2] = (double)pointInferiorLowZ[2] * z_spacing;
        ConjugateDirectionSearch optimizer = new ConjugateDirectionSearch();
        optimizer.step = 0.5;
        double[] startValues = new double[3];
        double my_guess_x = 356.0 * x_spacing;
        double my_guess_y = 459.0 * y_spacing;
        double my_guess_z = 45.0 * z_spacing;
        startValues[0] = (double)width * x_spacing / 2.0;
        startValues[1] = (double)height * y_spacing / 2.0;
        startValues[2] = (double)depth * z_spacing / 2.0;
        SphereAttempt attempt = new SphereAttempt(2);
        for (int shell = 0; shell < 2; ++shell) {
            int[][] pointsThisTime = pointsInShells[shell];
            for (int i = 0; i < pointsThisTime.length; ++i) {
                attempt.addPointInShell(shell, (double)pointsThisTime[i][0] * x_spacing, (double)pointsThisTime[i][1] * y_spacing, (double)pointsThisTime[i][2] * z_spacing);
            }
        }
        optimizer.optimize((MultivariateFunction)attempt, startValues, 2.0, 2.0);
        double resultScaled_x = startValues[0];
        double resultScaled_y = startValues[1];
        double resultScaled_z = startValues[2];
        double maxAngle = Math.atan((pointMaxZDefiningAngle[2] - resultScaled_z) / (resultScaled_x - pointMaxZDefiningAngle[0]));
        double minAngle = Math.atan((pointMinZDefiningAngle[2] - resultScaled_z) / (resultScaled_x - pointMinZDefiningAngle[0]));
        System.out.println("maxAngle is " + maxAngle + " (in degrees: " + maxAngle * 180.0 / Math.PI + ")");
        System.out.println("minAngle is " + minAngle + " (in degrees: " + minAngle * 180.0 / Math.PI + ")");
        double[] radii = new double[pointsInShells.length];
        for (int shell = 0; shell < pointsInShells.length; ++shell) {
            double distanceSum = 0.0;
            int[][] points = pointsInShells[shell];
            for (int i = 0; i < points.length; ++i) {
                double x = (double)points[i][0] * x_spacing;
                double y = (double)points[i][1] * y_spacing;
                double z = (double)points[i][2] * z_spacing;
                double x_diff = x - resultScaled_x;
                double y_diff = y - resultScaled_y;
                double z_diff = z - resultScaled_z;
                double d = Math.sqrt(x_diff * x_diff + y_diff * y_diff + z_diff * z_diff);
                distanceSum += d;
            }
            radii[shell] = distanceSum / (double)points.length;
        }
        double resultUnscaled_x = resultScaled_x / x_spacing;
        double resultUnscaled_y = resultScaled_y / y_spacing;
        double resultUnscaled_z = resultScaled_z / z_spacing;
        double result_x = (int)resultUnscaled_x;
        double result_y = (int)resultUnscaled_y;
        double result_z = (int)resultUnscaled_z;
        ShellsCanvas testCanvas = new ShellsCanvas(imp, resultScaled_x, resultScaled_y, resultScaled_z);
        for (int i = 0; i < radii.length; ++i) {
            testCanvas.addRadius(radii[i]);
        }
        new StackWindow(imp, (ImageCanvas)testCanvas);
        imp.show();
        String heatmapPath = "/Users/mark/central-complex-complete-vib-protocol/fb-average.tif";
        ImagePlus[] heatmapChannels = BatchOpener.open((String)heatmapPath);
        if (heatmapChannels == null) {
            IJ.error((String)("Couldn't open: " + heatmapPath));
            return;
        }
        boolean[][] include = new boolean[depth][];
        byte[][] excludedByAngle = new byte[depth][width * height];
        double maxDistanceSquared = 0.0;
        double minDistanceSquared = Double.MAX_VALUE;
        ImagePlus heatmap = heatmapChannels[0];
        ImageStack heatmapStack = heatmap.getStack();
        int includeOverAndIncluding = 127;
        for (int z = 0; z < depth; ++z) {
            byte[] pixels = (byte[])heatmapStack.getPixels(z + 1);
            boolean[] includeSlice = new boolean[width * height];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    boolean includeThisOne;
                    double x_real = (double)x * x_spacing;
                    double y_real = (double)y * y_spacing;
                    double z_real = (double)z * z_spacing;
                    double x_diff = x_real - resultScaled_x;
                    double y_diff = y_real - resultScaled_y;
                    double z_diff = z_real - resultScaled_z;
                    double angle = Math.atan(z_diff / -x_diff);
                    if (angle > maxAngle || (double)x >= resultUnscaled_x) {
                        excludedByAngle[z][y * width + x] = -1;
                        continue;
                    }
                    if (angle < minAngle || (double)x >= resultUnscaled_x) {
                        excludedByAngle[z][y * width + x] = -1;
                        continue;
                    }
                    int value = pixels[y * width + x] & 0xFF;
                    includeSlice[y * width + x] = includeThisOne = value >= includeOverAndIncluding;
                    if (!includeThisOne) {
                        excludedByAngle[z][y * width + x] = -128;
                        continue;
                    }
                    double distanceSquared = x_diff * x_diff + y_diff * y_diff + z_diff * z_diff;
                    if (distanceSquared > maxDistanceSquared) {
                        maxDistanceSquared = distanceSquared;
                        continue;
                    }
                    if (!(distanceSquared < minDistanceSquared)) continue;
                    minDistanceSquared = distanceSquared;
                }
            }
            include[z] = includeSlice;
        }
        heatmap.close();
        ImageStack newStack = new ImageStack(width, height);
        for (int z = 0; z < depth; ++z) {
            ByteProcessor bp = new ByteProcessor(width, height);
            bp.setPixels((Object)excludedByAngle[z]);
            newStack.addSlice("", (ImageProcessor)bp);
        }
        ImagePlus newImagePlus = new ImagePlus("points excluded by angle", newStack);
        newImagePlus.show();
        boolean rescaleValues = false;
        double maxDistance = Math.sqrt(maxDistanceSquared);
        double minDistance = Math.sqrt(minDistanceSquared);
        System.out.println("All distances between: " + maxDistance + " and " + minDistance);
        String annotationScoresFilename = "/Users/mark/thesis/annotations-with-scores.csv";
        Hashtable<String, Integer> scoresHash = new Hashtable<String, Integer>();
        System.out.println("Trying to load: " + annotationScoresFilename);
        try {
            String line;
            BufferedReader f = new BufferedReader(new FileReader(annotationScoresFilename));
            int lineNumber = 0;
            while ((line = f.readLine()) != null) {
                if (++lineNumber == 1) continue;
                String[] fieldsSortOf = line.split(",");
                String fileName = fieldsSortOf[2];
                String scoreAsString = fieldsSortOf[3];
                try {
                    int scoreInt = Integer.parseInt(scoreAsString);
                    int lastDotIndex = fileName.lastIndexOf(".");
                    if (lastDotIndex > 0) {
                        fileName = fileName.substring(0, lastDotIndex);
                    }
                    System.out.println("got score " + scoreAsString + " for file " + fileName);
                    scoresHash.put(fileName, new Integer(scoreInt));
                }
                catch (NumberFormatException e) {
                    System.out.println("The score '" + scoreAsString + "' wasn't an integer - skipping that one.");
                }
            }
        }
        catch (IOException e) {
            IJ.error((String)("Error parsing the file " + annotationScoresFilename + ": " + e));
            return;
        }
        File filesDirectory = new File("/Users/mark/central-complex-complete-vib-protocol/warped_2");
        File nc82FilesDirectory = new File("/Users/mark/central-complex-complete-vib-protocol/warped_1");
        Pattern[] linesPatterns = new Pattern[]{Pattern.compile("71y"), Pattern.compile("210y"), Pattern.compile("c0*5"), Pattern.compile("c0*61"), Pattern.compile("760"), Pattern.compile("(876|924)")};
        int bins = 100;
        FileGroup[] fileGroupArray = new FileGroup[linesPatterns.length + 1];
        for (int i = 0; i < fileGroupArray.length; ++i) {
            fileGroupArray[i] = new FileGroup("group " + i);
        }
        Bins[] lineBins = new Bins[linesPatterns.length + 1];
        int totalGoodBrains = 0;
        for (int i = 0; i <= linesPatterns.length; ++i) {
            lineBins[i] = new Bins(bins, minDistance, maxDistance);
            Pattern pattern = i == linesPatterns.length ? Pattern.compile("^[a-zA-Z0-9][^/]+$") : linesPatterns[i];
            System.out.println("Finding files matching: /" + pattern + "/");
            File[] files = i == linesPatterns.length ? nc82FilesDirectory.listFiles() : filesDirectory.listFiles();
            for (int j = 0; j < files.length; ++j) {
                Integer scoreInteger;
                File f = files[j];
                if (!pattern.matcher(f.getName()).find()) continue;
                String nameWithoutExtension = f.getName();
                int lastDotIndex = nameWithoutExtension.lastIndexOf(".");
                if (lastDotIndex >= 0) {
                    nameWithoutExtension = nameWithoutExtension.substring(0, lastDotIndex);
                }
                if ((scoreInteger = (Integer)scoresHash.get(nameWithoutExtension)) != null) {
                    int score = scoreInteger;
                    System.out.println("... that had score " + score);
                    if (score < 6) continue;
                }
                fileGroupArray[i].add((Object)f);
                ++totalGoodBrains;
            }
        }
        File[] normalizedDirectories = new File[linesPatterns.length + 1];
        for (int i = 0; i <= linesPatterns.length; ++i) {
            String normalizedDirectory = normalizedRootDirectory + (i == linesPatterns.length ? "nc82" : linesPatterns[i].toString()) + File.separator;
            normalizedDirectories[i] = new File(normalizedDirectory);
            System.out.println("Going to create: " + normalizedDirectory);
            boolean result = normalizedDirectories[i].mkdir();
            System.out.println("   result was: " + result);
            Quantile_Based_Normalization qbn = new Quantile_Based_Normalization();
            qbn.processToDirectory(fileGroupArray[i], normalizedDirectories[i].getAbsolutePath(), false, heatmapPath, 0, 256, false, false);
        }
        int brainCounter = 0;
        Bins[] brainBins = new Bins[totalGoodBrains];
        String[] brainLines = new String[totalGoodBrains];
        String[] brainNames = new String[totalGoodBrains];
        for (int i = 0; i <= linesPatterns.length; ++i) {
            File directory = normalizedDirectories[i];
            File[] files = directory.listFiles();
            for (int j = 0; j < files.length; ++j) {
                File f = files[j];
                System.out.println("looking at values in: " + f);
                ImagePlus[] gal4Channels = BatchOpener.open((String)f.getAbsolutePath());
                if (gal4Channels == null) {
                    IJ.error((String)("Couldn't open file: " + f));
                    return;
                }
                ImagePlus gal4Channel = gal4Channels[0];
                ImageStack gal4Stack = gal4Channel.getStack();
                int maxValue = -1;
                if (rescaleValues) {
                    maxValue = this.maxValueInImage(gal4Channel, include);
                    System.out.println("Rescaling with old maxValue: " + maxValue);
                }
                for (int z = 0; z < depth; ++z) {
                    byte[] pixels = (byte[])gal4Stack.getPixels(z + 1);
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            if (!include[z][y * width + x]) continue;
                            double x_real = (double)x * x_spacing;
                            double y_real = (double)y * y_spacing;
                            double z_real = (double)z * z_spacing;
                            double x_diff = x_real - resultScaled_x;
                            double y_diff = y_real - resultScaled_y;
                            double z_diff = z_real - resultScaled_z;
                            double distance = Math.sqrt(x_diff * x_diff + y_diff * y_diff + z_diff * z_diff);
                            int value = pixels[y * width + x] & 0xFF;
                            if (rescaleValues) {
                                value = 255 * value / maxValue;
                            }
                            lineBins[i].add(value, distance);
                            brainBins[brainCounter].add(value, distance);
                            brainLines[brainCounter] = directory.getName();
                            brainNames[brainCounter] = f.getName();
                        }
                    }
                }
                gal4Channel.close();
                ++brainCounter;
            }
        }
        String outputPathStem = "/Users/mark/central-complex-complete-vib-protocol/mhl-output/";
        try {
            for (int i = 0; i <= linesPatterns.length; ++i) {
                String outputPath = i == linesPatterns.length ? outputPathStem + "nc82.tsv" : outputPathStem + linesPatterns[i] + ".tsv";
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(outputPath))));
                pw.println("Pattern\tBin\tMinimumInBin\tMaximumInBin\tMidPointOfBin\tMeanValueInBin\tSDOfValuesInBin\t +N");
                String lineName = i == linesPatterns.length ? "nc82" : linesPatterns[i].toString();
                Bins lineBin = lineBins[i];
                for (int b = 0; b < bins; ++b) {
                    pw.println("\"" + lineName + "\"\t" + b + "\t" + lineBin.getMinimumInBin(b) + "\t" + lineBin.getMaximumInBin(b) + "\t" + lineBin.getMidPointOfBin(b) + "\t" + lineBin.getMean(b) + "\t" + lineBin.getStandardDeviation(b) + "\t" + lineBin.getN(b));
                }
                pw.close();
            }
            File perBrainSubdirectory = new File(outputPathStem + "per-brain");
            perBrainSubdirectory.mkdir();
            for (int i = 0; i <= brainBins.length; ++i) {
                String outputPath = perBrainSubdirectory.getAbsolutePath() + File.separator + brainNames[i] + ".tsv";
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(outputPath))));
                pw.println("Pattern\tBin\tMinimumInBin\tMaximumInBin\tMidPointOfBin\tMeanValueInBin\tSDOfValuesInBin\t +N");
                Bins brainBin = brainBins[i];
                for (int b = 0; b < bins; ++b) {
                    pw.println("\"" + brainLines[i] + "\"\t" + b + "\t" + brainBin.getMinimumInBin(b) + "\t" + brainBin.getMaximumInBin(b) + "\t" + brainBin.getMidPointOfBin(b) + "\t" + brainBin.getMean(b) + "\t" + brainBin.getStandardDeviation(b) + "\t" + brainBin.getN(b));
                }
                pw.close();
            }
        }
        catch (IOException e) {
            IJ.error((String)("There was an exception while writing the data: " + e));
            return;
        }
    }

    private int maxValueInImage(ImagePlus imp, boolean[][] includedVoxels) {
        int maxValue = 0;
        ImageStack stack = imp.getStack();
        int width = imp.getWidth();
        int height = imp.getHeight();
        int depth = imp.getStackSize();
        for (int z = 0; z < depth; ++z) {
            byte[] pixels = (byte[])stack.getPixels(z + 1);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int value;
                    if (!includedVoxels[z][y * width + x] || (value = pixels[y * width + x] & 0xFF) <= maxValue) continue;
                    maxValue = value;
                }
            }
        }
        return maxValue;
    }

    class SphereAttempt
    implements MultivariateFunction {
        ArrayList<ArrayList<double[]>> pointsInShells = new ArrayList();

        SphereAttempt(int shells) {
            for (int i = 0; i < shells; ++i) {
                this.pointsInShells.add(new ArrayList());
            }
        }

        public double evaluate(double[] argument) {
            double variancesSummed = 0.0;
            for (int shell = 0; shell < this.pointsInShells.size(); ++shell) {
                ArrayList<double[]> points = this.pointsInShells.get(shell);
                double sumDSquared = 0.0;
                double sumD = 0.0;
                int n = points.size();
                double centre_x = argument[0];
                double centre_y = argument[1];
                double centre_z = argument[2];
                for (double[] p : points) {
                    double xdiff = p[0] - centre_x;
                    double ydiff = p[1] - centre_y;
                    double zdiff = p[2] - centre_z;
                    double distanceSquared = xdiff * xdiff + ydiff * ydiff + zdiff * zdiff;
                    double distance = Math.sqrt(distanceSquared);
                    sumDSquared += distanceSquared;
                    sumD += distance;
                }
                double variance = sumDSquared / (double)n - sumD * sumD / (double)(n * n);
                variancesSummed += variance;
            }
            return variancesSummed;
        }

        public int getNumArguments() {
            return 3;
        }

        public double getLowerBound(int n) {
            return 0.0;
        }

        public double getUpperBound(int n) {
            return 10000.0;
        }

        public void addPointInShell(int shell, double x, double y, double z) {
            if (shell < 0 || shell >= this.pointsInShells.size()) {
                IJ.error((String)("There are only " + shell + " (trying to insert into shell " + shell + ")"));
                return;
            }
            double[] newPoint = new double[]{x, y, z};
            this.pointsInShells.get(shell).add(newPoint);
        }
    }
}

