/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TextEncoder {
    private ImageProcessor ip;
    private Calibration cal;
    private int precision;
    private String delimiter = "\t";

    public TextEncoder(ImageProcessor ip, Calibration cal, int precision) {
        this.ip = ip;
        this.cal = cal;
        this.precision = precision;
    }

    public void write(DataOutputStream out) throws IOException {
        boolean calibrated;
        PrintWriter pw = new PrintWriter(out);
        boolean bl = calibrated = this.cal != null && this.cal.calibrated();
        if (calibrated) {
            this.ip.setCalibrationTable(this.cal.getCTable());
        } else {
            this.ip.setCalibrationTable(null);
        }
        boolean intData = !calibrated && (this.ip instanceof ByteProcessor || this.ip instanceof ShortProcessor);
        int width = this.ip.getWidth();
        int height = this.ip.getHeight();
        int inc = height / 20;
        if (inc < 1) {
            inc = 1;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double value = this.ip.getPixelValue(x, y);
                if (intData) {
                    pw.print((int)value);
                } else {
                    pw.print(IJ.d2s(value, this.precision));
                }
                if (x == width - 1) continue;
                pw.print(this.delimiter);
            }
            pw.println();
            if (y % inc != 0) continue;
            IJ.showProgress((double)y / (double)height);
        }
        pw.close();
        IJ.showProgress(1.0);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

