/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.function.SingleOperandPixelBasedAbstractFunction;
import fiji.expressionparser.function.TwoOperandsPixelBasedAbstractFunction;
import net.imglib2.type.numeric.RealType;
import org.nfunk.jep.ParseException;

public final class ImgLibLogical {
    public static final String DOCUMENTATION_STRING_AND = "<h3>Element-wise 'AND' logical operation</h3> This function performs the pixel-wise logical AND operation, extended to real numbers. That is: the value returned by this operation will be the float value 1 if and only if the its operands are non zero, and 0 otherwise.";
    public static final String DOCUMENTATION_STRING_OR = "<h3>Element-wise 'OR' logical operation</h3> This function performs the pixel-wise logical OR operation, extended to real numbers. That is: the value returned by this operation will be the float value 1 if one of its two operands is non zero, and 0 if and only if the two operands are 0.";
    public static final String DOCUMENTATION_STRING_NOT = "<h3>Element-wise 'NOT' logical operation</h3> This function performs the pixel-wise logical NOT operation, extended to real numbers. That is: the value returned by this operation will be the float value 1 if its operand is zero, and will be 0 otherwise.";

    public static final class Not<T extends RealType<T>>
    extends SingleOperandPixelBasedAbstractFunction<T> {
        public Not() {
            this.numberOfParameters = 1;
        }

        @Override
        public final <R extends RealType<R>> float evaluate(R t) throws ParseException {
            return t.getRealFloat() == 0.0f ? 1.0f : 0.0f;
        }

        @Override
        public String getDocumentationString() {
            return ImgLibLogical.DOCUMENTATION_STRING_NOT;
        }

        @Override
        public String getFunctionString() {
            return "!";
        }
    }

    public static final class Or<T extends RealType<T>>
    extends TwoOperandsPixelBasedAbstractFunction<T> {
        public Or() {
            this.numberOfParameters = 2;
        }

        @Override
        public final <R extends RealType<R>> float evaluate(R t1, R t2) throws ParseException {
            return t1.getRealFloat() != 0.0f || t2.getRealFloat() != 0.0f ? 1.0f : 0.0f;
        }

        @Override
        public String getDocumentationString() {
            return ImgLibLogical.DOCUMENTATION_STRING_OR;
        }

        @Override
        public String getFunctionString() {
            return "||";
        }
    }

    public static final class And<T extends RealType<T>>
    extends TwoOperandsPixelBasedAbstractFunction<T> {
        public And() {
            this.numberOfParameters = 2;
        }

        @Override
        public final <R extends RealType<R>> float evaluate(R t1, R t2) throws ParseException {
            return t1.getRealFloat() != 0.0f && t2.getRealFloat() != 0.0f ? 1.0f : 0.0f;
        }

        @Override
        public String getDocumentationString() {
            return ImgLibLogical.DOCUMENTATION_STRING_AND;
        }

        @Override
        public String getFunctionString() {
            return "&&";
        }
    }
}

