/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import net.imagej.Dataset;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.FilamentWorkflow;
import sc.fiji.filamentdetector.FilesUtils;
import sc.fiji.filamentdetector.exporter.CSVFilamentExporter;
import sc.fiji.filamentdetector.exporter.CSVTrackedFilamentExporter;
import sc.fiji.filamentdetector.exporter.DataExporter;
import sc.fiji.filamentdetector.exporter.IJ1RoiFilamentExporter;
import sc.fiji.filamentdetector.exporter.JSONFilamentExporter;
import sc.fiji.filamentdetector.exporter.JSONTrackedFilamentExporter;
import sc.fiji.filamentdetector.gui.controller.AbstractController;
import sc.fiji.filamentdetector.model.Filaments;
import sc.fiji.filamentdetector.model.TrackedFilaments;

public class DataExporterController
extends AbstractController
implements Initializable {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/DataExporterView.fxml";
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private StatusService status;
    @FXML
    private Label filamentsLabel;
    @FXML
    private ComboBox<DataExporter<Filaments>> filamentsExporterBox;
    @FXML
    private Button exportFilamentsButton;
    @FXML
    private Label trackedFilamentsLabel;
    @FXML
    private ComboBox<DataExporter<TrackedFilaments>> trackedFilamentsExporterBox;
    @FXML
    private Button exportTrackedFilamentsButton;
    @FXML
    private Label filamentExporterDescription;
    @FXML
    private Label trackedFilamentExporterDescription;
    private FilamentWorkflow filamentWorkflow;
    private List<DataExporter<Filaments>> filamentsExporters;
    private List<DataExporter<TrackedFilaments>> trackedFilamentsExporters;

    public DataExporterController(Context context, FilamentWorkflow filamentWorkflow) {
        context.inject((Object)this);
        this.setFXMLPath(FXML_PATH);
        this.filamentWorkflow = filamentWorkflow;
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.refreshData(null);
        this.filamentsExporterBox.setCellFactory((Callback)new Callback<ListView<DataExporter<Filaments>>, ListCell<DataExporter<Filaments>>>(){

            public ListCell<DataExporter<Filaments>> call(ListView<DataExporter<Filaments>> p) {
                return new ListCell<DataExporter<Filaments>>(){

                    protected void updateItem(DataExporter<Filaments> t, boolean bln) {
                        super.updateItem(t, bln);
                        if (t != null) {
                            this.setText(t.getName());
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        });
        this.trackedFilamentsExporterBox.setCellFactory((Callback)new Callback<ListView<DataExporter<TrackedFilaments>>, ListCell<DataExporter<TrackedFilaments>>>(){

            public ListCell<DataExporter<TrackedFilaments>> call(ListView<DataExporter<TrackedFilaments>> p) {
                return new ListCell<DataExporter<TrackedFilaments>>(){

                    protected void updateItem(DataExporter<TrackedFilaments> t, boolean bln) {
                        super.updateItem(t, bln);
                        if (t != null) {
                            this.setText(t.getName());
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        });
        this.filamentsExporterBox.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
            if (newValue != null) {
                this.filamentExporterDescription.setText(newValue.getDescription());
            }
        });
        this.trackedFilamentsExporterBox.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
            if (newValue != null) {
                this.trackedFilamentExporterDescription.setText(newValue.getDescription());
            }
        });
        this.filamentsExporters = new ArrayList<DataExporter<Filaments>>();
        this.filamentsExporters.add(new JSONFilamentExporter(this.context, this.filamentWorkflow.getCalibrations()));
        this.filamentsExporters.add(new IJ1RoiFilamentExporter(this.context));
        this.filamentsExporters.add(new CSVFilamentExporter(this.context, this.filamentWorkflow.getCalibrations()));
        this.trackedFilamentsExporters = new ArrayList<DataExporter<TrackedFilaments>>();
        this.trackedFilamentsExporters.add(new JSONTrackedFilamentExporter(this.context, this.filamentWorkflow.getCalibrations()));
        this.trackedFilamentsExporters.add(new CSVTrackedFilamentExporter(this.context, this.filamentWorkflow.getCalibrations()));
        this.filamentsExporterBox.setItems(FXCollections.observableList(this.filamentsExporters));
        this.filamentsExporterBox.getSelectionModel().selectFirst();
        this.trackedFilamentsExporterBox.setItems(FXCollections.observableList(this.trackedFilamentsExporters));
        this.trackedFilamentsExporterBox.getSelectionModel().selectFirst();
    }

    @FXML
    public void refreshData(MouseEvent event) {
        if (this.filamentWorkflow.getFilaments() != null && this.filamentWorkflow.getFilaments().size() > 0) {
            this.filamentsLabel.setText(this.filamentWorkflow.getFilaments().size() + " filaments");
            this.filamentsExporterBox.setDisable(false);
            this.exportFilamentsButton.setDisable(false);
        } else {
            this.filamentsLabel.setText("No filaments");
            this.filamentsExporterBox.setDisable(true);
            this.exportFilamentsButton.setDisable(true);
        }
        if (this.filamentWorkflow.getTrackedFilaments() != null && this.filamentWorkflow.getTrackedFilaments().size() > 0) {
            this.trackedFilamentsLabel.setText(this.filamentWorkflow.getTrackedFilaments().size() + " tracked filaments");
            this.trackedFilamentsExporterBox.setDisable(false);
            this.exportTrackedFilamentsButton.setDisable(false);
        } else {
            this.trackedFilamentsLabel.setText("No tracked filaments");
            this.trackedFilamentsExporterBox.setDisable(true);
            this.exportTrackedFilamentsButton.setDisable(true);
        }
    }

    @FXML
    void exportFilaments(MouseEvent event) {
        DataExporter exporter = (DataExporter)this.filamentsExporterBox.getSelectionModel().getSelectedItem();
        File file = this.fileChooser(exporter);
        if (file != null) {
            exporter.export(this.filamentWorkflow.getFilaments(), file);
            this.status.showStatus("Filaments have been saved at " + file.getAbsolutePath());
        }
    }

    @FXML
    void exportTrackedFilaments(MouseEvent event) {
        DataExporter exporter = (DataExporter)this.trackedFilamentsExporterBox.getSelectionModel().getSelectedItem();
        File file = this.fileChooser(exporter);
        if (file != null) {
            exporter.export(this.filamentWorkflow.getTrackedFilaments(), file);
            this.status.showStatus("Filaments have been saved at " + file.getAbsolutePath());
        }
    }

    private File fileChooser(DataExporter<?> exporter) {
        String parentPath;
        FileChooser fileChooser = new FileChooser();
        Dataset dataset = (Dataset)this.filamentWorkflow.getSourceImage().getActiveView().getData();
        File initialDirectory = null;
        if (dataset.getSource() != null && (parentPath = new File(dataset.getSource()).getParent()) != null) {
            initialDirectory = new File(parentPath);
        }
        if (initialDirectory == null) {
            initialDirectory = new File(System.getProperty("user.home"));
        }
        fileChooser.setInitialDirectory(initialDirectory);
        if (dataset.getName() != null) {
            String fname = FilesUtils.getFileNameWithoutExtension(dataset.getName());
            fileChooser.setInitialFileName(fname);
        }
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(exporter.getExtensionDescription(), exporter.getExtensionFilters());
        fileChooser.getExtensionFilters().add((Object)extFilter);
        return fileChooser.showSaveDialog(this.getPane().getScene().getWindow());
    }
}

