/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.overlay;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.imagej.lut.LUTService;
import net.imglib2.display.ColorTable;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import sc.fiji.filamentdetector.overlay.ColorService;

@Plugin(type=Service.class)
public class DefaultColorService
extends AbstractService
implements ColorService {
    private static String DEFAULT_LUT = "glasbey";
    private static Map<String, URL> customLUTs;
    @Parameter
    private LUTService lutService;
    @Parameter
    private LogService log;
    private String lut;
    private ColorTable colorTable;

    @Override
    public int getLength() {
        return this.colorTable.getLength();
    }

    @Override
    public String getLut() {
        return this.lut;
    }

    @Override
    public void initialize() {
        this.initialize(DEFAULT_LUT);
    }

    @Override
    public void initialize(String lut) {
        try {
            if (customLUTs.containsKey(lut)) {
                this.lut = lut;
                this.colorTable = this.lutService.loadLUT(customLUTs.get(lut));
            } else if (this.lutService.findLUTs().containsKey(lut)) {
                this.lut = lut;
                this.colorTable = this.lutService.loadLUT((URL)this.lutService.findLUTs().get(lut));
            } else {
                this.log.error((Object)("Can't load LUT called '" + lut + "'"));
            }
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
    }

    @Override
    public Color getColor(int colorCounter) {
        if (colorCounter >= this.getLength()) {
            colorCounter %= this.getLength();
        }
        Color color = null;
        if (this.colorTable.getComponentCount() == 3) {
            color = new Color(this.colorTable.get(0, colorCounter), this.colorTable.get(1, colorCounter), this.colorTable.get(2, colorCounter));
        } else if (this.colorTable.getComponentCount() == 4) {
            color = new Color(this.colorTable.get(0, colorCounter), this.colorTable.get(1, colorCounter), this.colorTable.get(2, colorCounter), this.colorTable.get(3, colorCounter));
        } else {
            this.log.error((Object)"Invalid color component.");
        }
        return color;
    }

    static {
        HashMap<String, URL> aMap = new HashMap<String, URL>();
        aMap.put("glasbey", DefaultColorService.class.getResource("/luts/glasbey.lut"));
        customLUTs = Collections.unmodifiableMap(aMap);
    }
}

