/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

import de.biomedical_imaging.ij.steger.LinesUtil;
import de.biomedical_imaging.ij.steger.Normal;
import org.apache.commons.lang3.mutable.MutableLong;

public class Convol {
    private final double SQRT_2_PI_INV = 0.3989422804014327;

    private double phi0(double x, double sigma) {
        return Normal.getNormal(x / sigma);
    }

    private double phi1(double x, double sigma) {
        double t = x / sigma;
        return 0.3989422804014327 / sigma * Math.exp(-0.5 * t * t);
    }

    public double phi2(double x, double sigma) {
        double t = x / sigma;
        return -x * 0.3989422804014327 / Math.pow(sigma, 3.0) * Math.exp(-0.5 * t * t);
    }

    public double[] compute_gauss_mask_0(MutableLong num, double sigma) {
        double limit = LinesUtil.MASK_SIZE(3.09023230616781, sigma);
        int n = (int)limit;
        double[] h = new double[2 * n + 1];
        for (int i = -n + 1; i <= n - 1; ++i) {
            h[n + i] = this.phi0((double)(-i) + 0.5, sigma) - this.phi0((double)(-i) - 0.5, sigma);
        }
        h[0] = 1.0 - this.phi0((double)n - 0.5, sigma);
        h[2 * n] = this.phi0((double)(-n) + 0.5, sigma);
        num.setValue((long)n);
        return h;
    }

    public double[] compute_gauss_mask_1(MutableLong num, double sigma) {
        double limit = LinesUtil.MASK_SIZE(3.46087178201605, sigma);
        int n = (int)limit;
        double[] h = new double[2 * n + 1];
        for (int i = -n + 1; i <= n - 1; ++i) {
            h[n + i] = this.phi1((double)(-i) + 0.5, sigma) - this.phi1((double)(-i) - 0.5, sigma);
        }
        h[0] = -this.phi1((double)n - 0.5, sigma);
        h[2 * n] = this.phi1((double)(-n) + 0.5, sigma);
        num.setValue((long)n);
        return h;
    }

    public double[] compute_gauss_mask_2(MutableLong num, double sigma) {
        double limit = LinesUtil.MASK_SIZE(3.82922419517181, sigma);
        int n = (int)limit;
        double[] h = new double[2 * n + 1];
        for (int i = -n + 1; i <= n - 1; ++i) {
            h[n + i] = this.phi2((double)(-i) + 0.5, sigma) - this.phi2((double)(-i) - 0.5, sigma);
        }
        h[0] = -this.phi2((double)n - 0.5, sigma);
        h[2 * n] = this.phi2((double)(-n) + 0.5, sigma);
        num.setValue((long)n);
        return h;
    }

    private void convolve_rows_gauss(float[] image, double[] mask, int n, float[] h, int width, int height) {
        int j;
        double sum;
        int l;
        int c;
        int r;
        for (r = n; r < height - n; ++r) {
            for (c = 0; c < width; ++c) {
                l = LinesUtil.LINCOOR(r, c, width);
                sum = 0.0;
                for (j = -n; j <= n; ++j) {
                    sum += (double)image[l + j * width] * mask[j + n];
                }
                h[l] = (float)sum;
            }
        }
        for (r = 0; r < n; ++r) {
            for (c = 0; c < width; ++c) {
                l = LinesUtil.LINCOOR(r, c, width);
                sum = 0.0;
                for (j = -n; j <= n; ++j) {
                    sum += (double)image[LinesUtil.LINCOOR(LinesUtil.BR(r + j, height), c, width)] * mask[j + n];
                }
                h[l] = (float)sum;
            }
        }
        for (r = height - n; r < height; ++r) {
            for (c = 0; c < width; ++c) {
                l = LinesUtil.LINCOOR(r, c, width);
                sum = 0.0;
                for (j = -n; j <= n; ++j) {
                    sum += (double)image[LinesUtil.LINCOOR(LinesUtil.BR(r + j, height), c, width)] * mask[j + n];
                }
                h[l] = (float)sum;
            }
        }
    }

    private void convolve_cols_gauss(float[] h, double[] mask, int n, float[] k, int width, int height) {
        int j;
        double sum;
        int l;
        int c;
        int r;
        for (r = 0; r < height; ++r) {
            for (c = n; c < width - n; ++c) {
                l = LinesUtil.LINCOOR(r, c, width);
                sum = 0.0;
                for (j = -n; j <= n; ++j) {
                    sum += (double)h[l + j] * mask[j + n];
                }
                k[l] = (float)sum;
            }
        }
        for (r = 0; r < height; ++r) {
            for (c = 0; c < n; ++c) {
                l = LinesUtil.LINCOOR(r, c, width);
                sum = 0.0;
                for (j = -n; j <= n; ++j) {
                    sum += (double)h[LinesUtil.LINCOOR(r, LinesUtil.BC(c + j, width), width)] * mask[j + n];
                }
                k[l] = (float)sum;
            }
        }
        for (r = 0; r < height; ++r) {
            for (c = width - n; c < width; ++c) {
                l = LinesUtil.LINCOOR(r, c, width);
                sum = 0.0;
                for (j = -n; j <= n; ++j) {
                    sum += (double)h[LinesUtil.LINCOOR(r, LinesUtil.BC(c + j, width), width)] * mask[j + n];
                }
                k[l] = (float)sum;
            }
        }
    }

    public void convolve_gauss(float[] image, float[] k, int width, int height, double sigma, int deriv_type) {
        double[] hr = null;
        double[] hc = null;
        MutableLong nr = new MutableLong();
        MutableLong nc = new MutableLong();
        float[] h = new float[width * height];
        switch (deriv_type) {
            case 1: {
                hr = this.compute_gauss_mask_1(nr, sigma);
                hc = this.compute_gauss_mask_0(nc, sigma);
                break;
            }
            case 2: {
                hr = this.compute_gauss_mask_0(nr, sigma);
                hc = this.compute_gauss_mask_1(nc, sigma);
                break;
            }
            case 3: {
                hr = this.compute_gauss_mask_2(nr, sigma);
                hc = this.compute_gauss_mask_0(nc, sigma);
                break;
            }
            case 4: {
                hr = this.compute_gauss_mask_1(nr, sigma);
                hc = this.compute_gauss_mask_1(nc, sigma);
                break;
            }
            case 5: {
                hr = this.compute_gauss_mask_0(nr, sigma);
                hc = this.compute_gauss_mask_2(nc, sigma);
            }
        }
        double[] maskr = hr;
        double[] maskc = hc;
        this.convolve_rows_gauss(image, maskr, nr.intValue(), h, width, height);
        this.convolve_cols_gauss(h, maskc, nc.intValue(), k, width, height);
    }
}

