/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import mpicbg.models.CoordinateTransform;

public class InterpolatedCoordinateTransform<A extends CoordinateTransform, B extends CoordinateTransform>
implements CoordinateTransform {
    private static final long serialVersionUID = 8356592128041276188L;
    protected final A a;
    protected final B b;
    protected double lambda;

    public InterpolatedCoordinateTransform(A a, B b, double lambda) {
        this.a = a;
        this.b = b;
        this.lambda = lambda;
    }

    public A getA() {
        return this.a;
    }

    public B getB() {
        return this.b;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(float lambda) {
        this.lambda = lambda;
    }

    @Override
    public double[] apply(double[] location) {
        double[] copy = (double[])location.clone();
        this.applyInPlace(copy);
        return copy;
    }

    @Override
    public void applyInPlace(double[] location) {
        double[] copy = this.b.apply(location);
        this.a.applyInPlace(location);
        int d = 0;
        while (d < location.length) {
            double dd = copy[d] - location[d];
            int n = d++;
            location[n] = location[n] + this.lambda * dd;
        }
    }
}

