/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.ui.keymap;

import bdv.TransformEventHandler3D;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.NavigationActions;
import bdv.viewer.ViewerState;
import bigwarp.BigWarpActions;
import java.util.stream.IntStream;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.Actions;

public class NavigationKeys
extends NavigationActions {
    public NavigationKeys(KeyStrokeAdder.Factory keyConfig) {
        super(keyConfig);
    }

    public static void install(Actions actions, AbstractViewerPanel viewer, boolean is2D) {
        NavigationKeys.installModeActions((Actions)actions, (ViewerState)viewer.state());
        NavigationKeys.installSourceActions((Actions)actions, (ViewerState)viewer.state());
        NavigationKeys.installTimeActions((Actions)actions, (ViewerState)viewer.state());
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(BigWarpActions.BIGWARP, new String[]{"bigwarp", "navigation", "bw-table"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add("toggle interpolation", NavigationActions.TOGGLE_INTERPOLATION_KEYS, "Switch between nearest-neighbor and n-linear interpolation mode in BigDataViewer.");
            descriptions.add("toggle fused mode", NavigationActions.TOGGLE_FUSED_MODE_KEYS, "TODO");
            descriptions.add("toggle grouping", NavigationActions.TOGGLE_GROUPING_KEYS, "TODO");
            String[] numkeys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
            IntStream.range(0, numkeys.length).forEach(i -> {
                descriptions.add(String.format("set current source %d", i), new String[]{String.format("%s", numkeys[i])}, "TODO");
                descriptions.add(String.format("toggle source visibility %d", i), new String[]{String.format("shift %s", numkeys[i])}, "TODO");
            });
            descriptions.add("next timepoint", NavigationActions.NEXT_TIMEPOINT_KEYS, "TODO");
            descriptions.add("previous timepoint", NavigationActions.PREVIOUS_TIMEPOINT_KEYS, "TODO");
            descriptions.add("align XY plane", NavigationActions.ALIGN_XY_PLANE_KEYS, "TODO");
            descriptions.add("align ZY plane", NavigationActions.ALIGN_ZY_PLANE_KEYS, "TODO");
            descriptions.add("align XZ plane", NavigationActions.ALIGN_XZ_PLANE_KEYS, "TODO");
            descriptions.add("drag translate", TransformEventHandler3D.DRAG_TRANSLATE_KEYS, "Pan the view by mouse-dragging.");
            descriptions.add("scroll zoom", TransformEventHandler3D.ZOOM_NORMAL_KEYS, "Zoom in by scrolling.");
            descriptions.add("axis x", TransformEventHandler3D.SELECT_AXIS_X_KEYS, "Select X as the rotation axis for keyboard rotation.");
            descriptions.add("axis y", TransformEventHandler3D.SELECT_AXIS_Y_KEYS, "Select Y as the rotation axis for keyboard rotation.");
            descriptions.add("axis z", TransformEventHandler3D.SELECT_AXIS_Z_KEYS, "Select Z as the rotation axis for keyboard rotation.");
            descriptions.add("drag rotate", TransformEventHandler3D.DRAG_ROTATE_KEYS, "Rotate the view by mouse-dragging.");
            descriptions.add("scroll browse z", TransformEventHandler3D.SCROLL_Z_KEYS, "Translate in Z by scrolling.");
            descriptions.add("rotate left", TransformEventHandler3D.ROTATE_LEFT_KEYS, "Rotate left (counter-clockwise) by 1 degree.");
            descriptions.add("rotate right", TransformEventHandler3D.ROTATE_RIGHT_KEYS, "Rotate right (clockwise) by 1 degree.");
            descriptions.add("zoom in", TransformEventHandler3D.KEY_ZOOM_IN_KEYS, "Zoom in.");
            descriptions.add("zoom out", TransformEventHandler3D.KEY_ZOOM_OUT_KEYS, "Zoom out.");
            descriptions.add("forward z", TransformEventHandler3D.KEY_FORWARD_Z_KEYS, "Translate forward in Z.");
            descriptions.add("backward z", TransformEventHandler3D.KEY_BACKWARD_Z_KEYS, "Translate backward in Z.");
            descriptions.add("drag rotate fast", TransformEventHandler3D.DRAG_ROTATE_FAST_KEYS, "Rotate the view by mouse-dragging (fast).");
            descriptions.add("scroll browse z fast", TransformEventHandler3D.SCROLL_Z_FAST_KEYS, "Translate in Z by scrolling (fast).");
            descriptions.add("rotate left fast", TransformEventHandler3D.ROTATE_LEFT_FAST_KEYS, "Rotate left (counter-clockwise) by 10 degrees.");
            descriptions.add("rotate right fast", TransformEventHandler3D.ROTATE_RIGHT_FAST_KEYS, "Rotate right (clockwise) by 10 degrees.");
            descriptions.add("zoom in fast", TransformEventHandler3D.KEY_ZOOM_IN_FAST_KEYS, "Zoom in (fast).");
            descriptions.add("zoom out fast", TransformEventHandler3D.KEY_ZOOM_OUT_FAST_KEYS, "Zoom out (fast).");
            descriptions.add("forward z fast", TransformEventHandler3D.KEY_FORWARD_Z_FAST_KEYS, "Translate forward in Z (fast).");
            descriptions.add("backward z fast", TransformEventHandler3D.KEY_BACKWARD_Z_FAST_KEYS, "Translate backward in Z (fast).");
            descriptions.add("drag rotate slow", TransformEventHandler3D.DRAG_ROTATE_SLOW_KEYS, "Rotate the view by mouse-dragging (slow).");
            descriptions.add("scroll browse z slow", TransformEventHandler3D.SCROLL_Z_SLOW_KEYS, "Translate in Z by scrolling (slow).");
            descriptions.add("rotate left slow", TransformEventHandler3D.ROTATE_LEFT_SLOW_KEYS, "Rotate left (counter-clockwise) by 0.1 degree.");
            descriptions.add("rotate right slow", TransformEventHandler3D.ROTATE_RIGHT_SLOW_KEYS, "Rotate right (clockwise) by 0.1 degree.");
            descriptions.add("zoom in slow", TransformEventHandler3D.KEY_ZOOM_IN_SLOW_KEYS, "Zoom in (slow).");
            descriptions.add("zoom out slow", TransformEventHandler3D.KEY_ZOOM_OUT_SLOW_KEYS, "Zoom out (slow).");
            descriptions.add("forward z slow", TransformEventHandler3D.KEY_FORWARD_Z_SLOW_KEYS, "Translate forward in Z (slow).");
            descriptions.add("backward z slow", TransformEventHandler3D.KEY_BACKWARD_Z_SLOW_KEYS, "Translate backward in Z (slow).");
        }
    }
}

