/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.convert;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.AbstractUnaryBlockOperator;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.ClampType;
import net.imglib2.algorithm.blocks.DefaultUnaryBlockOperator;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.algorithm.blocks.convert.ConvertBlockProcessor;
import net.imglib2.algorithm.blocks.convert.ConverterBlockProcessor;
import net.imglib2.converter.Converter;
import net.imglib2.type.NativeType;
import net.imglib2.util.Cast;

public class Convert {
    public static <S extends NativeType<S>, T extends NativeType<T>> Function<BlockSupplier<S>, UnaryBlockOperator<S, T>> convert(T targetType) {
        return Convert.convert(targetType, ClampType.NONE);
    }

    public static <S extends NativeType<S>, T extends NativeType<T>> Function<BlockSupplier<S>, UnaryBlockOperator<S, T>> convert(T targetType, ClampType clamp) {
        return s -> Convert.createOperator((NativeType)s.getType(), targetType, clamp);
    }

    public static <S extends NativeType<S>, T extends NativeType<T>> Function<BlockSupplier<S>, UnaryBlockOperator<S, T>> convert(T targetType, Supplier<Converter<? super S, T>> converterSupplier) {
        return s -> Convert.createOperator((NativeType)s.getType(), targetType, converterSupplier);
    }

    public static <S extends NativeType<S>, T extends NativeType<T>> UnaryBlockOperator<S, T> createOperator(S sourceType, T targetType) {
        return Convert.createOperator(sourceType, targetType, ClampType.NONE);
    }

    public static <S extends NativeType<S>, T extends NativeType<T>> UnaryBlockOperator<S, T> createOperator(S sourceType, T targetType, ClampType clamp) {
        if (Objects.equals(sourceType.getClass(), targetType.getClass())) {
            return (UnaryBlockOperator)Cast.unchecked(new Identity<S>(sourceType, 0));
        }
        return new DefaultUnaryBlockOperator<S, T>(sourceType, targetType, 0, 0, new ConvertBlockProcessor(sourceType, targetType, clamp));
    }

    public static <S extends NativeType<S>, T extends NativeType<T>> UnaryBlockOperator<S, T> createOperator(S sourceType, T targetType, Supplier<Converter<? super S, T>> converterSupplier) {
        return new DefaultUnaryBlockOperator<S, T>(sourceType, targetType, 0, 0, new ConverterBlockProcessor(sourceType, targetType, converterSupplier));
    }

    static class Identity<T extends NativeType<T>>
    extends AbstractUnaryBlockOperator<T, T> {
        protected Identity(T type, int numDimensions) {
            super(type, type, numDimensions, numDimensions);
        }

        protected Identity(AbstractUnaryBlockOperator<T, T> op) {
            super(op);
        }

        @Override
        public void compute(BlockSupplier<T> src, Interval interval, Object dest) {
            src.copy(interval, dest);
        }

        @Override
        public UnaryBlockOperator<T, T> independentCopy() {
            return this;
        }

        @Override
        public BlockSupplier<T> applyTo(BlockSupplier<T> blocks) {
            return blocks;
        }

        @Override
        public <U extends NativeType<U>> UnaryBlockOperator<T, U> andThen(UnaryBlockOperator<T, U> op) {
            return op;
        }
    }
}

