/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.transform;

import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.transform.AbstractTransformProcessor;
import net.imglib2.algorithm.blocks.transform.Transform;
import net.imglib2.algorithm.blocks.transform.TransformLine3D;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.PrimitiveType;

class Affine3DProcessor<P>
extends AbstractTransformProcessor<P> {
    private final AffineTransform3D transformToSource;
    private final TransformLine3D<P> transformLine;
    private final double[] pdest = new double[3];
    private final double[] psrc = new double[3];

    Affine3DProcessor(AffineTransform3D transformToSource, Transform.Interpolation interpolation, PrimitiveType primitiveType) {
        this(transformToSource, interpolation, primitiveType, TransformLine3D.of(interpolation, primitiveType));
    }

    private Affine3DProcessor(AffineTransform3D transformToSource, Transform.Interpolation interpolation, PrimitiveType primitiveType, TransformLine3D<P> transformLine) {
        super(3, interpolation, primitiveType);
        this.transformToSource = transformToSource;
        this.transformLine = transformLine;
    }

    private Affine3DProcessor(Affine3DProcessor<P> processor) {
        super(processor);
        this.transformToSource = processor.transformToSource;
        this.transformLine = processor.transformLine;
    }

    @Override
    public BlockProcessor<P, P> independentCopy() {
        return new Affine3DProcessor<P>(this);
    }

    @Override
    RealInterval estimateBounds(Interval interval) {
        return this.transformToSource.estimateBounds((RealInterval)interval);
    }

    @Override
    public void compute(P src, P dest) {
        float d0 = this.transformToSource.d(0).getFloatPosition(0);
        float d1 = this.transformToSource.d(0).getFloatPosition(1);
        float d2 = this.transformToSource.d(0).getFloatPosition(2);
        int ds0 = this.destSize[0];
        int ss0 = this.sourceSize[0];
        int ss1 = this.sourceSize[1] * ss0;
        this.pdest[0] = this.destPos[0];
        int i = 0;
        for (int z = 0; z < this.destSize[2]; ++z) {
            this.pdest[2] = (long)z + this.destPos[2];
            for (int y = 0; y < this.destSize[1]; ++y) {
                this.pdest[1] = (long)y + this.destPos[1];
                this.transformToSource.apply(this.pdest, this.psrc);
                float sf0 = (float)(this.psrc[0] - (double)this.sourcePos[0]);
                float sf1 = (float)(this.psrc[1] - (double)this.sourcePos[1]);
                float sf2 = (float)(this.psrc[2] - (double)this.sourcePos[2]);
                this.transformLine.apply(src, dest, i, ds0, d0, d1, d2, ss0, ss1, sf0, sf1, sf2);
                i += ds0;
            }
        }
    }
}

