/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;

public class IndexItem<A extends Annotation> {
    private final Class<A> annotation;
    private final ClassLoader loader;
    private final String className;
    private final Map<Object, Object> map;

    IndexItem(Class<A> annotation, ClassLoader loader, String className, Map<Object, Object> map) {
        this.annotation = annotation;
        this.loader = loader;
        this.className = className;
        this.map = map;
    }

    public A annotation() {
        return IndexItem.proxy(this.annotation, this.loader, this.className, this.map);
    }

    public String className() {
        return this.className;
    }

    private static <A extends Annotation> A proxy(final Class<A> annotation, final ClassLoader loader, final String className, final Map<Object, Object> map) {
        return (A)((Annotation)Proxy.newProxyInstance(loader, new Class[]{annotation}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object value;
                if (map.containsKey(method)) {
                    return map.get(method);
                }
                String name = method.getName();
                if (map.containsKey(name)) {
                    value = map.get(name);
                    Class<?> expectedType = method.getReturnType();
                    if (!expectedType.isAssignableFrom(value.getClass())) {
                        value = IndexItem.adapt(value, loader, expectedType, className);
                    }
                } else if (name.equals("toString") && (args == null || args.length == 0)) {
                    value = "@" + annotation.getName() + map;
                } else if (name.equals("annotationType") && (args == null || args.length == 0)) {
                    value = annotation;
                } else {
                    if (name.equals("hashCode") && (args == null || args.length == 0)) {
                        return annotation.hashCode() ^ map.hashCode();
                    }
                    if (name.equals("equals") && args != null && args.length == 1) {
                        if (!(args[0] instanceof Annotation) || ((Annotation)args[0]).annotationType() != annotation) {
                            return false;
                        }
                        for (Method method2 : annotation.getMethods()) {
                            if (method2.getDeclaringClass() != annotation || this.invoke(proxy, method2, new Object[0]).equals(method2.invoke(args[0], new Object[0]))) continue;
                            return false;
                        }
                        return true;
                    }
                    value = method.getDefaultValue();
                    if (value == null) {
                        throw new IllegalArgumentException("Could not find value for " + name);
                    }
                }
                map.put(method, value);
                return value;
            }
        }));
    }

    private static Object adapt(Object o, ClassLoader loader, Class<?> expectedType, String className) {
        if (o == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(o.getClass())) {
            return o;
        }
        if (o instanceof Boolean) {
            return (boolean)((Boolean)o);
        }
        if (o instanceof Long) {
            long l = (Long)o;
            if (expectedType == Byte.TYPE) {
                return (byte)l;
            }
            if (expectedType == Short.TYPE) {
                return (short)l;
            }
            if (expectedType == Integer.TYPE) {
                return (int)l;
            }
            if (expectedType == Long.TYPE) {
                return l;
            }
        } else {
            if (o instanceof Double) {
                double d = (Double)o;
                if (expectedType == Float.TYPE) {
                    return Float.valueOf((float)d);
                }
                return d;
            }
            if (expectedType == Character.TYPE) {
                String s = (String)o;
                if (s.length() == 1) {
                    return Character.valueOf(s.charAt(0));
                }
            } else {
                if (expectedType == Class.class) {
                    try {
                        return loader.loadClass((String)o);
                    }
                    catch (Throwable t) {
                        throw IndexItem.cce(o, expectedType, className, t);
                    }
                }
                if (expectedType.isArray()) {
                    List list = (List)o;
                    Class<?> type = expectedType.getComponentType();
                    int length = list.size();
                    Object array = Array.newInstance(type, length);
                    for (int i = 0; i < length; ++i) {
                        Array.set(array, i, IndexItem.adapt(list.get(i), loader, type, className));
                    }
                    return array;
                }
                if (Enum.class.isAssignableFrom(expectedType)) {
                    Map map = (Map)o;
                    String enumName = (String)map.get("enum");
                    String constName = (String)map.get("value");
                    try {
                        return loader.loadClass(enumName).getField(constName).get(null);
                    }
                    catch (Throwable t) {
                        throw IndexItem.cce(o, expectedType, className, t);
                    }
                }
                if (Annotation.class.isAssignableFrom(expectedType)) {
                    Class<?> annotation = expectedType;
                    Map map = (Map)o;
                    return IndexItem.proxy(annotation, loader, className, map);
                }
            }
        }
        throw IndexItem.cce(o, expectedType, className, null);
    }

    private static ClassCastException cce(Object o, Class<?> expectedType, String className, Throwable cause) {
        String oType = o == null ? "<null>" : o.getClass().getName();
        String eType = expectedType == null ? "<null>" : expectedType.getName();
        ClassCastException cce = new ClassCastException(className + ": cannot cast object of type " + oType + " to " + eType);
        if (cause != null) {
            cce.initCause(cause);
        }
        return cce;
    }
}

