/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import org.scijava.Context;
import org.scijava.log.IgnoreAsCallingClass;

@IgnoreAsCallingClass
public final class CallingClassUtils {
    private CallingClassUtils() {
    }

    public static String getCallingClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stackTrace.length - 2; ++i) {
            String className = stackTrace[i].getClassName();
            if (CallingClassUtils.hasIgnoreAsCallingClassAnnotation(className)) continue;
            return className;
        }
        return stackTrace[stackTrace.length - 1].getClassName();
    }

    private static boolean hasIgnoreAsCallingClassAnnotation(String className) {
        try {
            Class<?> clazz = Context.getClassLoader().loadClass(className);
            return clazz.isAnnotationPresent(IgnoreAsCallingClass.class);
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    @Deprecated
    public static Class<?> getCallingClass() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 1; i < stackTrace.length - 1; ++i) {
                Class<?> clazz = Class.forName(stackTrace[i].getClassName());
                if (clazz.isAnnotationPresent(IgnoreAsCallingClass.class)) continue;
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new IllegalStateException();
    }
}

