/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.control.mcu;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.janelia.saalfeldlab.control.VPotControl;
import org.janelia.saalfeldlab.control.mcu.MCUControl;

public class MCUVPotControl
extends MCUControl
implements VPotControl {
    private static final int STATUS = 176;
    private static final int[] LED_CODES = new int[]{0, 0, 16, 32, 48};
    private int min = 0;
    private int max = 127;
    private final int led;
    private int ledType = 3;
    private boolean absolute = true;
    private final Receiver rec;
    private final ShortMessage ledMsg = new ShortMessage();
    private final ScheduledThreadPoolExecutor resetExec = new ScheduledThreadPoolExecutor(1);
    private Future<?> resetTask;

    public MCUVPotControl(int led, Receiver rec) {
        this.led = led;
        this.rec = rec;
    }

    private void send(ShortMessage msg) throws InvalidMidiDataException {
        this.rec.send(msg, System.currentTimeMillis());
    }

    public void display() {
        int ledCode = LED_CODES[this.ledType];
        if (this.absolute) {
            int j;
            double n = this.max - this.min;
            if (this.listeners.size() == 0) {
                j = 0;
            } else {
                switch (this.ledType) {
                    case 0: {
                        j = 0;
                        break;
                    }
                    case 4: {
                        j = Math.max(1, Math.min(6, (int)Math.floor(6.0 * (double)(this.value - this.min) / n) + 1));
                        break;
                    }
                    default: {
                        j = Math.max(1, Math.min(11, (int)Math.floor(11.0 * (double)(this.value - this.min) / n) + 1));
                    }
                }
            }
            try {
                this.ledMsg.setMessage(176, this.led, ledCode | j);
                this.send(this.ledMsg);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        } else {
            int k;
            int j;
            if (this.listeners.size() == 0) {
                j = 0;
                k = 0;
            } else {
                switch (this.ledType) {
                    case 0: {
                        j = 0;
                        k = 0;
                        break;
                    }
                    case 4: {
                        j = Math.max(1, Math.min(6, (int)Math.floor(0.42857142857142855 * (double)Math.abs(this.value) + 3.0) + 1));
                        k = 1;
                        break;
                    }
                    default: {
                        j = Math.max(1, Math.min(11, (int)Math.floor(11.0 * (double)(this.value + 7) / 14.0) + 1));
                        k = 6;
                    }
                }
            }
            try {
                if (this.resetTask != null) {
                    this.resetTask.cancel(false);
                }
                this.resetExec.purge();
                this.ledMsg.setMessage(176, this.led, ledCode | j);
                this.send(this.ledMsg);
                this.resetTask = this.resetExec.schedule(() -> {
                    try {
                        this.ledMsg.setMessage(176, this.led, ledCode | k);
                        this.send(this.ledMsg);
                        this.resetTask = null;
                    }
                    catch (InvalidMidiDataException e) {
                        e.printStackTrace();
                    }
                }, 200L, TimeUnit.MILLISECONDS);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
    }

    void setValueSilently(int value) {
        this.value = Math.min(this.max, Math.max(this.min, value));
    }

    @Override
    public void setValue(int value) {
        this.setValueSilently(value);
        this.display();
        for (IntConsumer listener : this.listeners) {
            listener.accept(value);
        }
    }

    @Override
    public int getMin() {
        return this.absolute ? this.min : -7;
    }

    @Override
    public int getMax() {
        return this.absolute ? this.max : 7;
    }

    @Override
    public void setMin(int min) {
        this.min = min;
        this.display();
    }

    @Override
    public void setMax(int max) {
        this.max = max;
        this.display();
    }

    @Override
    public void setMinMax(int min, int max) {
        this.min = min;
        this.max = max;
        this.display();
    }

    @Override
    void update(int data) {
        int d = (0x40 & data) == 0 ? data : -(0xF & data);
        this.setValue(this.absolute ? this.value + d : d);
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    @Override
    public void setDisplayType(int display) {
        this.ledType = display;
        this.display();
    }

    @Override
    public boolean addListener(IntConsumer listener) {
        boolean result = super.addListener(listener);
        this.display();
        return result;
    }

    @Override
    public boolean removeListener(IntConsumer listener) {
        boolean result = super.removeListener(listener);
        this.display();
        return result;
    }

    @Override
    public void clearListeners() {
        super.clearListeners();
        this.display();
    }
}

