/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.scijava.display.Display;
import org.scijava.display.event.input.KyPressedEvent;
import org.scijava.display.event.input.KyReleasedEvent;
import org.scijava.display.event.input.KyTypedEvent;
import org.scijava.display.event.input.MsClickedEvent;
import org.scijava.display.event.input.MsDraggedEvent;
import org.scijava.display.event.input.MsEnteredEvent;
import org.scijava.display.event.input.MsExitedEvent;
import org.scijava.display.event.input.MsMovedEvent;
import org.scijava.display.event.input.MsPressedEvent;
import org.scijava.display.event.input.MsReleasedEvent;
import org.scijava.display.event.input.MsWheelEvent;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.input.InputModifiers;
import org.scijava.input.KeyCode;

public class AWTInputEventDispatcher
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final Display<?> display;
    private final EventService eventService;
    private int x = -1;
    private int y = -1;

    public AWTInputEventDispatcher(Display<?> display) {
        this(display, (EventService)display.getContext().getService(EventService.class));
    }

    public AWTInputEventDispatcher(Display<?> display, EventService eventService) {
        this.display = display;
        this.eventService = eventService;
    }

    public void register(Component c, boolean keyEvents, boolean mouseEvents) {
        if (keyEvents) {
            c.addKeyListener(this);
        }
        if (mouseEvents) {
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
            c.addMouseWheelListener(this);
        }
    }

    public int getLastX() {
        return this.x;
    }

    public int getLastY() {
        return this.y;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        char keyChar = e.getKeyChar();
        KeyCode keyCode = KeyCode.get((int)e.getKeyCode());
        KyTypedEvent evt = new KyTypedEvent(this.display, modifiers, this.x, this.y, keyChar, keyCode);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        char keyChar = e.getKeyChar();
        KeyCode keyCode = KeyCode.get((int)e.getKeyCode());
        KyPressedEvent evt = new KyPressedEvent(this.display, modifiers, this.x, this.y, keyChar, keyCode);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        KeyCode keyCode = KeyCode.get((int)e.getKeyCode());
        char keyChar = e.getKeyChar();
        KyReleasedEvent evt = new KyReleasedEvent(this.display, modifiers, this.x, this.y, keyChar, keyCode);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        this.updateMouseCoords(e);
        int clickCount = e.getClickCount();
        boolean isPopupTrigger = e.isPopupTrigger();
        MsClickedEvent evt = new MsClickedEvent(this.display, modifiers, this.x, this.y, this.mouseButton(e), clickCount, isPopupTrigger);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        this.updateMouseCoords(e);
        int clickCount = e.getClickCount();
        boolean isPopupTrigger = e.isPopupTrigger();
        MsPressedEvent evt = new MsPressedEvent(this.display, modifiers, this.x, this.y, this.mouseButton(e), clickCount, isPopupTrigger);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        this.updateMouseCoords(e);
        int clickCount = e.getClickCount();
        boolean isPopupTrigger = e.isPopupTrigger();
        MsReleasedEvent evt = new MsReleasedEvent(this.display, modifiers, this.x, this.y, this.mouseButton(e), clickCount, isPopupTrigger);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        this.updateMouseCoords(e);
        MsEnteredEvent evt = new MsEnteredEvent(this.display, modifiers, this.x, this.y);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        this.updateMouseCoords(e);
        MsExitedEvent evt = new MsExitedEvent(this.display, modifiers, this.x, this.y);
        this.clearMouseCoords();
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        this.updateMouseCoords(e);
        int clickCount = e.getClickCount();
        boolean isPopupTrigger = e.isPopupTrigger();
        MsDraggedEvent evt = new MsDraggedEvent(this.display, modifiers, this.x, this.y, this.mouseButton(e), clickCount, isPopupTrigger);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        this.updateMouseCoords(e);
        MsMovedEvent evt = new MsMovedEvent(this.display, modifiers, this.x, this.y);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        InputModifiers modifiers = this.createModifiers(e.getModifiersEx());
        this.updateMouseCoords(e);
        int wheelRotation = e.getWheelRotation();
        MsWheelEvent evt = new MsWheelEvent(this.display, modifiers, this.x, this.y, wheelRotation);
        this.eventService.publish((SciJavaEvent)evt);
        if (evt.isConsumed()) {
            e.consume();
        }
    }

    private InputModifiers createModifiers(int modsEx) {
        boolean altDown = this.isOn(modsEx, 512);
        boolean altGrDown = this.isOn(modsEx, 8192);
        boolean ctrlDown = this.isOn(modsEx, 128);
        boolean metaDown = this.isOn(modsEx, 256);
        boolean shiftDown = this.isOn(modsEx, 64);
        boolean leftButtonDown = this.isOn(modsEx, 1024);
        boolean middleButtonDown = this.isOn(modsEx, 4096);
        boolean rightButtonDown = this.isOn(modsEx, 2048);
        return new InputModifiers(altDown, altGrDown, ctrlDown, metaDown, shiftDown, leftButtonDown, middleButtonDown, rightButtonDown);
    }

    private boolean isOn(int modsEx, int mask) {
        return (modsEx & mask) != 0;
    }

    private int mouseButton(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    private void updateMouseCoords(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
    }

    private void clearMouseCoords() {
        this.y = -1;
        this.x = -1;
    }
}

