/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axes;

import java.util.Optional;
import javax.annotation.Nullable;

public enum Unit {
    angstrom("space"),
    attometer("space"),
    centimeter("space"),
    decimeter("space"),
    exameter("space"),
    femtometer("space"),
    foot("space"),
    gigameter("space"),
    hectometer("space"),
    inch("space"),
    kilometer("space"),
    megameter("space"),
    meter("space"),
    micrometer("space"),
    mile("space"),
    millimeter("space"),
    nanometer("space"),
    parsec("space"),
    petameter("space"),
    picometer("space"),
    terameter("space"),
    yard("space"),
    yoctometer("space"),
    yottameter("space"),
    zeptometer("space"),
    zettameter("space"),
    attosecond("time"),
    centisecond("time"),
    day("time"),
    decisecond("time"),
    exasecond("time"),
    femtosecond("time"),
    gigasecond("time"),
    hectosecond("time"),
    hour("time"),
    kilosecond("time"),
    megasecond("time"),
    microsecond("time"),
    millisecond("time"),
    minute("time"),
    nanosecond("time"),
    petasecond("time"),
    picosecond("time"),
    second("time"),
    terasecond("time"),
    yoctosecond("time"),
    yottasecond("time"),
    zeptosecond("time"),
    zettasecond("time");

    private final String type;
    public static final char MICRO = '\u00b5';
    public static final char MU = '\u03bc';

    private Unit(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean isType(String type) {
        return this.type.equals(type.toLowerCase());
    }

    @Nullable
    public static Unit fromString(String unitString) {
        String unitNorm = unitString.trim();
        return Unit.tryParse(unitNorm.toLowerCase()).orElse(Unit.fromAbbreviation(unitNorm));
    }

    private static Optional<Unit> tryParse(String unit) {
        try {
            return Optional.of(Unit.valueOf(unit.toLowerCase()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    @Nullable
    private static Unit fromAbbreviation(String abbrev) {
        return Unit.fromSiAbbreviation(abbrev).orElse(Unit.fromOtherAbbreviation(abbrev.toLowerCase()).orElse(null));
    }

    private static Optional<Unit> fromSiAbbreviation(String si) {
        if (si.length() == 1) {
            return Unit.tryParse(Unit.siUnitFromSymbol(si.charAt(0)));
        }
        if (si.length() == 2) {
            return Unit.tryParse(Unit.siPrefixFromSymbol(si.charAt(0)) + Unit.siUnitFromSymbol(si.charAt(1)));
        }
        return Optional.empty();
    }

    private static String siPrefixFromSymbol(char prefix) {
        switch (prefix) {
            case 'Q': {
                return "quetta";
            }
            case 'R': {
                return "rotta";
            }
            case 'Y': {
                return "yotta";
            }
            case 'Z': {
                return "zetta";
            }
            case 'E': {
                return "exa";
            }
            case 'P': {
                return "peta";
            }
            case 'T': {
                return "tera";
            }
            case 'G': {
                return "giga";
            }
            case 'M': {
                return "mega";
            }
            case 'k': {
                return "kilo";
            }
            case 'h': {
                return "hecto";
            }
            case 'd': {
                return "deci";
            }
            case 'c': {
                return "centi";
            }
            case 'm': {
                return "milli";
            }
            case 'u': {
                return "micro";
            }
            case '\u03bc': {
                return "micro";
            }
            case '\u00b5': {
                return "micro";
            }
            case 'n': {
                return "nano";
            }
            case 'p': {
                return "pico";
            }
            case 'f': {
                return "fempto";
            }
            case 'a': {
                return "atto";
            }
            case 'z': {
                return "zepto";
            }
            case 'y': {
                return "yocto";
            }
        }
        return null;
    }

    private static String siUnitFromSymbol(char suffix) {
        switch (suffix) {
            case 'm': {
                return "meter";
            }
            case 's': {
                return "second";
            }
        }
        return null;
    }

    private static Optional<Unit> fromOtherAbbreviation(String abbreviation) {
        switch (abbreviation) {
            case "in": {
                return Optional.of(inch);
            }
            case "ft": {
                return Optional.of(foot);
            }
            case "yd": {
                return Optional.of(yard);
            }
            case "mi": {
                return Optional.of(mile);
            }
            case "pc": {
                return Optional.of(parsec);
            }
            case "min": {
                return Optional.of(minute);
            }
            case "sec": {
                return Optional.of(second);
            }
            case "hr": {
                return Optional.of(hour);
            }
            case "d": {
                return Optional.of(day);
            }
        }
        return Optional.empty();
    }
}

