/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import net.imglib2.realtransform.RealTransform;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.IdentityCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ScaleCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.TranslationCoordinateTransform;

public interface CoordinateTransform<T extends RealTransform> {
    public static final String KEY = "coordinateTransformations";

    public T getTransform();

    default public T getTransform(N5Reader n5) {
        return this.getTransform();
    }

    public String getName();

    public String getType();

    public String getInput();

    public String getOutput();

    public String[] getInputAxes();

    public String[] getOutputAxes();

    public static CoordinateTransform<?> create(CoordinateTransform<?> ct) {
        if (ct instanceof CoordinateTransform) {
            return ct;
        }
        switch (ct.getType()) {
            case "identity": {
                return new IdentityCoordinateTransform();
            }
            case "scale": {
                return new ScaleCoordinateTransform((ScaleCoordinateTransform)ct);
            }
            case "translation": {
                return new TranslationCoordinateTransform((TranslationCoordinateTransform)ct);
            }
        }
        return null;
    }
}

