/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.translation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunctionLoader;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.jackson.jq.path.Path;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.CompressionAdapter;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.GsonN5Reader;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataNode;
import org.janelia.saalfeldlab.n5.universe.metadata.axisTransforms.TransformAxes;
import org.janelia.saalfeldlab.n5.universe.metadata.axisTransforms.TransformAxesMetadataAdapter;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadataAdapter;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SpatialTransformAdapter;
import org.janelia.saalfeldlab.n5.universe.translation.ImportedTranslations;

public class JqUtils {
    public static String resolveImports(String query) {
        if (query.startsWith("include")) {
            return new ImportedTranslations().getTranslation() + query.replaceFirst("^\\s*include\\s+\"n5\"\\s*;", "");
        }
        return query;
    }

    public static Scope buildRootScope() {
        Scope rootScope = Scope.newEmptyScope();
        BuiltinFunctionLoader.getInstance().loadFunctions(Versions.JQ_1_6, rootScope);
        rootScope.addFunction("repeat", 1, new Function(){

            public void apply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
                args.get(0).apply(scope, in, time -> output.emit((JsonNode)new TextNode(Strings.repeat((String)in.asText(), (int)time.asInt())), null));
            }
        });
        return rootScope;
    }

    public static GsonBuilder gsonBuilder(N5Reader n5) {
        GsonBuilder gsonBuilder = n5 instanceof GsonN5Reader ? ((GsonN5Reader)n5).getGson().newBuilder() : new GsonBuilder();
        gsonBuilder.registerTypeAdapter(SpatialTransform.class, (Object)new SpatialTransformAdapter(n5));
        gsonBuilder.registerTypeAdapter(CanonicalMetadata.class, (Object)new CanonicalMetadataAdapter());
        gsonBuilder.registerTypeAdapter(DataType.class, (Object)new DataType.JsonAdapter());
        gsonBuilder.registerTypeAdapter(TransformAxes.class, (Object)new TransformAxesMetadataAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(Compression.class, (Object)CompressionAdapter.getJsonAdapter());
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ExcludeParentGsonFromContainerMetadata()});
        gsonBuilder.disableHtmlEscaping();
        return gsonBuilder;
    }

    public static GsonBuilder newBuilder(Gson gson) {
        GsonBuilder gsonBuilder = gson.newBuilder();
        gsonBuilder.registerTypeAdapter(SpatialTransform.class, (Object)new SpatialTransformAdapter(null));
        gsonBuilder.registerTypeAdapter(CanonicalMetadata.class, (Object)new CanonicalMetadataAdapter());
        gsonBuilder.registerTypeAdapter(DataType.class, (Object)new DataType.JsonAdapter());
        gsonBuilder.registerTypeAdapter(TransformAxes.class, (Object)new TransformAxesMetadataAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(Compression.class, (Object)CompressionAdapter.getJsonAdapter());
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ExcludeParentGsonFromContainerMetadata()});
        return gsonBuilder;
    }

    public static Gson buildGson(N5Reader n5) {
        return JqUtils.gsonBuilder(n5).create();
    }

    public String transform(String in, String translation, ObjectMapper objMapper, Scope scope) throws JsonMappingException, JsonProcessingException {
        JsonNode inJsonNode = objMapper.readTree(in);
        ArrayList out = new ArrayList();
        JsonQuery.compile((String)translation, (Version)Versions.JQ_1_6).apply(scope, inJsonNode, out::add);
        StringBuffer stringOutput = new StringBuffer();
        for (JsonNode n : out) {
            stringOutput.append(n.toString() + "\n");
        }
        return stringOutput.toString();
    }

    private static class ExcludeParentGsonFromContainerMetadata
    implements ExclusionStrategy {
        private ExcludeParentGsonFromContainerMetadata() {
        }

        public boolean shouldSkipField(FieldAttributes f) {
            Class declaringClass = f.getDeclaringClass();
            boolean isContainerMetadataNode = declaringClass.equals(ContainerMetadataNode.class);
            boolean isGsonReader = declaringClass.equals(GsonN5Reader.class);
            return isGsonReader && f.getName().equals("gson");
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }
}

